/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.repositories;

import com.dynatrace.android.sessionreplay.data.daos.EventDAO;
import com.dynatrace.android.sessionreplay.model.DataError;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u000e\u001a\u00020\u000bJ(\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r\u0012\u0004\u0012\u00020\t0\u0007J\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000bJ&\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\r\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\u0018\u001a\u00020\u00192\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/dynatrace/android/sessionreplay/data/repositories/EventRepository;", "", "eventDAO", "Lcom/dynatrace/android/sessionreplay/data/daos/EventDAO;", "<init>", "(Lcom/dynatrace/android/sessionreplay/data/daos/EventDAO;)V", "get", "Lcom/dynatrace/android/sessionreplay/model/Result;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Lcom/dynatrace/android/sessionreplay/model/DataError;", "eventId", "", "getByVisitId", "", "visitId", "getBetweenSystemTimes", "systemStartTime", "", "systemEndTime", "getAll", "create", "event", "update", "events", "delete", "", "datalayer_release"})
public final class EventRepository {
    @NotNull
    private final EventDAO eventDAO;

    public EventRepository(@NotNull EventDAO eventDAO) {
        Intrinsics.checkNotNullParameter((Object)eventDAO, (String)"eventDAO");
        this.eventDAO = eventDAO;
    }

    @NotNull
    public final Result<Event, DataError> get(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        return this.eventDAO.get(eventId);
    }

    @NotNull
    public final Result<List<Event>, DataError> getByVisitId(@NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        return this.eventDAO.getByVisitId(visitId);
    }

    @NotNull
    public final Result<List<Event>, DataError> getBetweenSystemTimes(long systemStartTime, long systemEndTime) {
        return this.eventDAO.getBetweenSystemTimes(systemStartTime, systemEndTime);
    }

    @NotNull
    public final Result<List<Event>, DataError> getAll() {
        return this.eventDAO.getAll();
    }

    @NotNull
    public final Result<Event, DataError> create(@NotNull Event event, @NotNull String visitId) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)visitId, (String)"visitId");
        return this.eventDAO.create(event, visitId);
    }

    @NotNull
    public final Result<List<Event>, DataError> update(@NotNull List<? extends Event> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        return this.eventDAO.update(events);
    }

    public final void delete(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this.eventDAO.delete(eventId);
    }

    public final void delete(@NotNull List<String> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        this.eventDAO.deleteAll(events);
    }
}

