/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.data.repositories;

import com.dynatrace.android.sessionreplay.data.daos.ImageDAO;
import com.dynatrace.android.sessionreplay.data.screenshots.ScreenshotInfo;
import com.dynatrace.android.sessionreplay.model.FileError;
import com.dynatrace.android.sessionreplay.model.Result;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000f\u0012\u0004\u0012\u00020\u000b0\tJ\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\nJ\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\t2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0016J\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/dynatrace/android/sessionreplay/data/repositories/ImageRepository;", "", "imageDAO", "Lcom/dynatrace/android/sessionreplay/data/daos/ImageDAO;", "maxStorageCapacityInB", "", "<init>", "(Lcom/dynatrace/android/sessionreplay/data/daos/ImageDAO;J)V", "get", "Lcom/dynatrace/android/sessionreplay/model/Result;", "", "Lcom/dynatrace/android/sessionreplay/model/FileError;", "imageId", "", "getAll", "", "save", "Lcom/dynatrace/android/sessionreplay/data/screenshots/ScreenshotInfo;", "screenshotInfo", "image", "deleteAll", "exceptions", "", "delete", "", "canImageFit", "imageSize", "getCurrentScreenshotsSizeInB", "Companion", "datalayer_release"})
public final class ImageRepository {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ImageDAO imageDAO;
    private final long maxStorageCapacityInB;
    private static final long MAX_CAPACITY_IN_B = 0xA00000L;

    public ImageRepository(@NotNull ImageDAO imageDAO, long maxStorageCapacityInB) {
        Intrinsics.checkNotNullParameter((Object)imageDAO, (String)"imageDAO");
        this.imageDAO = imageDAO;
        this.maxStorageCapacityInB = maxStorageCapacityInB;
    }

    public /* synthetic */ ImageRepository(ImageDAO imageDAO, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0xA00000L;
        }
        this(imageDAO, l);
    }

    @NotNull
    public final Result<byte[], FileError> get(@NotNull String imageId) {
        Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
        return this.imageDAO.get(imageId);
    }

    @NotNull
    public final Result<List<byte[]>, FileError> getAll() {
        return this.imageDAO.getAll();
    }

    @NotNull
    public final Result<ScreenshotInfo, FileError> save(@NotNull ScreenshotInfo screenshotInfo, @NotNull byte[] image) {
        Intrinsics.checkNotNullParameter((Object)screenshotInfo, (String)"screenshotInfo");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Result<ScreenshotInfo, FileError> currentScreenshot = this.imageDAO.getInfo(screenshotInfo.getId());
        if (!(currentScreenshot instanceof Result.Success)) {
            if (currentScreenshot instanceof Result.Error) {
                long size = screenshotInfo.getSize();
                return this.getCurrentScreenshotsSizeInB() + size <= this.maxStorageCapacityInB ? this.imageDAO.save(screenshotInfo.getId(), image) : (Result)new Result.Error((Object)new FileError.StorageLimitReached(size));
            }
            throw new NoWhenBranchMatchedException();
        }
        return currentScreenshot;
    }

    @NotNull
    public final Result<Long, FileError> deleteAll(@NotNull Set<String> exceptions) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        this.imageDAO.deleteAll(exceptions);
        return (Result)new Result.Success((Object)(this.maxStorageCapacityInB - this.getCurrentScreenshotsSizeInB()));
    }

    public static /* synthetic */ Result deleteAll$default(ImageRepository imageRepository, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        return imageRepository.deleteAll(set);
    }

    @NotNull
    public final Result<Boolean, FileError> delete(@NotNull String imageId) {
        Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
        return (Result)new Result.Success((Object)this.imageDAO.delete(imageId));
    }

    public final boolean canImageFit(long imageSize) {
        return this.getCurrentScreenshotsSizeInB() + imageSize <= this.maxStorageCapacityInB;
    }

    private final long getCurrentScreenshotsSizeInB() {
        return ((Number)this.imageDAO.getCurrentStorageSize().getOrDefault((Object)0L)).longValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/data/repositories/ImageRepository$Companion;", "", "<init>", "()V", "MAX_CAPACITY_IN_B", "", "datalayer_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

