/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.model;

import com.dynatrace.android.sessionreplay.model.Checkpoint;
import com.dynatrace.android.sessionreplay.model.Durable;
import com.dynatrace.android.sessionreplay.model.Event;
import com.dynatrace.android.sessionreplay.model.EventType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nJ\b\u0010\u0016\u001a\u00020\u0006H\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/model/GestureEvent;", "Lcom/dynatrace/android/sessionreplay/model/Event;", "Lcom/dynatrace/android/sessionreplay/model/Durable;", "id", "", "startTime", "Ljava/util/Date;", "(Ljava/lang/String;Ljava/util/Date;)V", "_checkpoints", "", "Lcom/dynatrace/android/sessionreplay/model/Checkpoint;", "checkpoints", "", "getCheckpoints", "()Ljava/util/List;", "type", "Lcom/dynatrace/android/sessionreplay/model/EventType;", "getType", "()Lcom/dynatrace/android/sessionreplay/model/EventType;", "addCheckpoint", "", "checkpoint", "getEndTime", "removeCheckpoint", "model_release"})
public final class GestureEvent
extends Event
implements Durable {
    @NotNull
    private final EventType type;
    @NotNull
    private final List<Checkpoint> _checkpoints;
    @NotNull
    private final List<Checkpoint> checkpoints;

    public GestureEvent(@NotNull String id, @NotNull Date startTime) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        super(id, startTime, null, 0L, null, 16, null);
        this.type = EventType.GESTURE;
        this._checkpoints = new ArrayList();
        this.checkpoints = this._checkpoints;
    }

    public /* synthetic */ GestureEvent(String string, Date date, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            String string2 = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            string = string2;
        }
        if ((n & 2) != 0) {
            date = new Date();
        }
        this(string, date);
    }

    @Override
    @NotNull
    public EventType getType() {
        return this.type;
    }

    @NotNull
    public final List<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    public final void addCheckpoint(@NotNull Checkpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)checkpoint, (String)"checkpoint");
        this._checkpoints.add(checkpoint);
    }

    public final void removeCheckpoint(@NotNull Checkpoint checkpoint) {
        Intrinsics.checkNotNullParameter((Object)checkpoint, (String)"checkpoint");
        this._checkpoints.remove(checkpoint);
    }

    @Override
    @NotNull
    public Date getEndTime() {
        return new Date(this.getStartTime().getTime() + ((Checkpoint)CollectionsKt.last(this._checkpoints)).getElapsedTime());
    }

    public GestureEvent() {
        this(null, null, 3, null);
    }
}

