/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.extensions;

import android.graphics.Rect;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u001a,\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u0002*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002\u00a8\u0006\u0015"}, d2={"cropDividedHeight", "", "Landroid/graphics/Rect;", "original", "intersection", "cropDividedWidth", "", "getChopAmountsFrom", "Lkotlin/Pair;", "", "origin", "originIntersection", "size", "clear", "", "crop", "compareWith", "difference", "compareWithRects", "intersectWith", "rect", "trackinglayer_release"})
public final class RectExtensionsKt {
    public static final void clear(@NotNull Rect $this$clear) {
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)$this$clear, (String)"<this>");
        Rect $this$clear_u24lambda_u240 = rect = $this$clear;
        boolean bl = false;
        $this$clear_u24lambda_u240.left = 0;
        $this$clear_u24lambda_u240.right = 0;
        $this$clear_u24lambda_u240.top = 0;
    }

    @NotNull
    public static final Set<Rect> difference(@NotNull Rect $this$difference, @NotNull Set<Rect> compareWithRects) {
        Intrinsics.checkNotNullParameter((Object)$this$difference, (String)"<this>");
        Intrinsics.checkNotNullParameter(compareWithRects, (String)"compareWithRects");
        Set differenceRectangles = new LinkedHashSet();
        for (Rect rect : compareWithRects) {
            Set<Rect> elements = RectExtensionsKt.crop($this$difference, rect);
            differenceRectangles.addAll((Collection)elements);
        }
        if (differenceRectangles.size() > 1) {
            differenceRectangles.remove($this$difference);
        }
        return differenceRectangles;
    }

    @Nullable
    public static final Rect intersectWith(@NotNull Rect $this$intersectWith, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)$this$intersectWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Rect intersection = new Rect($this$intersectWith);
        if (intersection.intersect(rect)) {
            return intersection;
        }
        return null;
    }

    @NotNull
    public static final Set<Rect> crop(@NotNull Rect $this$crop, @NotNull Rect compareWith) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$crop, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)compareWith, (String)"compareWith");
                object = RectExtensionsKt.intersectWith($this$crop, compareWith);
                if (object == null) break block4;
                Rect intersection = object;
                boolean bl = false;
                Set<Rect> heightRectangles = RectExtensionsKt.cropDividedHeight($this$crop, intersection);
                Rect newRect = new Rect($this$crop.left, intersection.top, $this$crop.right, intersection.bottom);
                Rect rect = RectExtensionsKt.intersectWith(newRect, compareWith);
                if (rect != null) {
                    Rect it = rect;
                    boolean bl2 = false;
                    Set<Rect> widthRectangles = RectExtensionsKt.cropDividedWidth(newRect, intersection);
                    heightRectangles.addAll((Collection<Rect>)widthRectangles);
                }
                Set<Rect> set = heightRectangles;
                object = set;
                if (set != null) break block5;
            }
            Object[] objectArray = new Rect[]{$this$crop};
            object = SetsKt.mutableSetOf((Object[])objectArray);
        }
        return object;
    }

    private static final Set<Rect> cropDividedHeight(Rect original, Rect intersection) {
        Pair<Integer, Integer> pair = RectExtensionsKt.getChopAmountsFrom(original.top, intersection.top, intersection.height());
        int chopAmountTop = ((Number)pair.component1()).intValue();
        int chopAmountBottom = ((Number)pair.component2()).intValue();
        Set heightRectangles = new LinkedHashSet();
        Rect topRect = new Rect(original.left, original.top, original.right, original.top + chopAmountTop);
        Rect bottomRect = new Rect(original.left, original.top + chopAmountBottom, original.right, original.bottom);
        if (!topRect.isEmpty()) {
            heightRectangles.add(topRect);
        }
        if (!bottomRect.isEmpty()) {
            heightRectangles.add(bottomRect);
        }
        return heightRectangles;
    }

    private static final Set<Rect> cropDividedWidth(Rect original, Rect intersection) {
        Pair<Integer, Integer> pair = RectExtensionsKt.getChopAmountsFrom(original.left, intersection.left, intersection.width());
        int chopAmountLeft = ((Number)pair.component1()).intValue();
        int chopAmountRight = ((Number)pair.component2()).intValue();
        Set widthRectangles = new LinkedHashSet();
        Rect leftRect = new Rect(original.left, original.top, original.left + chopAmountLeft, original.bottom);
        Rect rightRect = new Rect(original.left + chopAmountRight, original.top, original.right, original.bottom);
        if (!leftRect.isEmpty()) {
            widthRectangles.add(leftRect);
        }
        if (!rightRect.isEmpty()) {
            widthRectangles.add(rightRect);
        }
        return widthRectangles;
    }

    private static final Pair<Integer, Integer> getChopAmountsFrom(int origin, int originIntersection, int size) {
        int chopAmountFirst = 0;
        int chopAmountSecond = 0;
        if (origin <= originIntersection) {
            int originAxis;
            chopAmountFirst = originAxis = originIntersection - origin;
            chopAmountSecond = originAxis + size;
        } else {
            int originAxis = originIntersection + size;
            chopAmountFirst = originAxis - origin;
            chopAmountSecond = originAxis;
        }
        return new Pair((Object)chopAmountFirst, (Object)chopAmountSecond);
    }
}

