/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl;

import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowInsets;
import com.dynatrace.android.sessionreplay.tracking.interceptors.KeyboardInterceptor;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.trackers.KeyboardTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.TrackerFactory;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\b\u0018\u00010\u0006R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/KeyboardInterceptorImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/KeyboardInterceptor;", "trackerFactory", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;", "(Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;)V", "keyboardLayoutListener", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/KeyboardInterceptorImpl$KeyboardLayoutListener;", "intercept", "", "rootView", "Landroid/view/View;", "decorView", "window", "Landroid/view/Window;", "KeyboardLayoutListener", "trackinglayer_release"})
public final class KeyboardInterceptorImpl
implements KeyboardInterceptor {
    @NotNull
    private final TrackerFactory trackerFactory;
    @Nullable
    private KeyboardLayoutListener keyboardLayoutListener;

    public KeyboardInterceptorImpl(@NotNull TrackerFactory trackerFactory) {
        Intrinsics.checkNotNullParameter((Object)trackerFactory, (String)"trackerFactory");
        this.trackerFactory = trackerFactory;
    }

    @Override
    public void intercept(@NotNull View rootView, @NotNull View decorView, @NotNull Window window) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            Intrinsics.checkNotNullParameter((Object)decorView, (String)"decorView");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            KeyboardTracker keyboardTracker = this.trackerFactory.getKeyboardTracker();
            if (keyboardTracker == null) break block0;
            KeyboardTracker keyboardTracker2 = keyboardTracker;
            boolean bl = false;
            this.keyboardLayoutListener = new KeyboardLayoutListener(keyboardTracker2, new WeakReference<View>(rootView), new WeakReference<View>(decorView), new WeakReference<Window>(window));
            rootView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.keyboardLayoutListener);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/KeyboardInterceptorImpl$KeyboardLayoutListener;", "Landroid/view/ViewTreeObserver$OnGlobalLayoutListener;", "keyboardTracker", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/KeyboardTracker;", "rootViewWeakReference", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "decorViewWeakReference", "windowWeakReference", "Landroid/view/Window;", "(Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/KeyboardInterceptorImpl;Lcom/dynatrace/android/sessionreplay/tracking/trackers/KeyboardTracker;Ljava/lang/ref/WeakReference;Ljava/lang/ref/WeakReference;Ljava/lang/ref/WeakReference;)V", "keyboardVisible", "", "isKeyboardVisible", "onGlobalLayout", "", "trackinglayer_release"})
    private final class KeyboardLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        @NotNull
        private final KeyboardTracker keyboardTracker;
        @NotNull
        private final WeakReference<View> rootViewWeakReference;
        @NotNull
        private final WeakReference<View> decorViewWeakReference;
        @NotNull
        private final WeakReference<Window> windowWeakReference;
        private boolean keyboardVisible;

        public KeyboardLayoutListener(@NotNull KeyboardTracker keyboardTracker, @NotNull WeakReference<View> rootViewWeakReference, @NotNull WeakReference<View> decorViewWeakReference, WeakReference<Window> windowWeakReference) {
            Intrinsics.checkNotNullParameter((Object)keyboardTracker, (String)"keyboardTracker");
            Intrinsics.checkNotNullParameter(rootViewWeakReference, (String)"rootViewWeakReference");
            Intrinsics.checkNotNullParameter(decorViewWeakReference, (String)"decorViewWeakReference");
            Intrinsics.checkNotNullParameter(windowWeakReference, (String)"windowWeakReference");
            this.keyboardTracker = keyboardTracker;
            this.rootViewWeakReference = rootViewWeakReference;
            this.decorViewWeakReference = decorViewWeakReference;
            this.windowWeakReference = windowWeakReference;
            this.keyboardVisible = this.isKeyboardVisible();
        }

        private final boolean isKeyboardVisible() {
            View view;
            return Build.VERSION.SDK_INT >= 30 ? ((view = (View)this.rootViewWeakReference.get()) != null && (view = view.getRootWindowInsets()) != null ? view.isVisible(WindowInsets.Type.ime()) : false) : false;
        }

        public void onGlobalLayout() {
            boolean newKeyboardVisibility;
            View decorView = (View)this.decorViewWeakReference.get();
            View rootView = (View)this.rootViewWeakReference.get();
            Window window = (Window)this.windowWeakReference.get();
            if (rootView != null && decorView != null && Build.VERSION.SDK_INT >= 30 && (newKeyboardVisibility = this.isKeyboardVisible()) != this.keyboardVisible) {
                this.keyboardVisible = newKeyboardVisibility;
                if (this.keyboardVisible) {
                    WindowInsets windowInsets = rootView.getRootWindowInsets();
                    if (windowInsets != null && (windowInsets = windowInsets.getInsets(WindowInsets.Type.ime())) != null) {
                        WindowInsets keyboardInset = windowInsets;
                        boolean bl = false;
                        this.keyboardTracker.trackKeyboardShown(new UIView(decorView, window, null, 4, null), 0, decorView.getHeight() - keyboardInset.bottom, decorView.getWidth(), keyboardInset.bottom);
                    }
                } else {
                    this.keyboardTracker.trackKeyboardHidden(new UIView(decorView, window, null, 4, null));
                }
            }
        }
    }
}

