/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound;

import android.annotation.SuppressLint;
import android.graphics.drawable.Animatable2;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.Switch;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.AnimationEnd;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0003\u001a\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u001a\u0010\t\u001a\u00020\n*\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"getAnimatedVectorDrawableOrNull", "Landroid/graphics/drawable/AnimatedVectorDrawable;", "drawable", "Landroid/graphics/drawable/Drawable;", "isAndroid24OrGreater", "", "getCustomButtonDrawable", "Landroid/widget/CompoundButton;", "compoundButton", "registerAnimatedDrawableListener", "", "listener", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/AnimationEnd;", "trackinglayer_release"})
public final class CompoundUtilsKt {
    @Nullable
    public static final AnimatedVectorDrawable getCustomButtonDrawable(@NotNull CompoundButton $this$getCustomButtonDrawable, @NotNull CompoundButton compoundButton) {
        AnimatedVectorDrawable animatedVectorDrawable;
        Intrinsics.checkNotNullParameter((Object)$this$getCustomButtonDrawable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)compoundButton, (String)"compoundButton");
        if (!CompoundUtilsKt.isAndroid24OrGreater()) {
            animatedVectorDrawable = null;
        } else if (compoundButton instanceof CheckBox || compoundButton instanceof RadioButton) {
            Drawable drawable = compoundButton.getButtonDrawable();
            if (drawable != null) {
                Drawable it = drawable;
                boolean bl = false;
                animatedVectorDrawable = CompoundUtilsKt.getAnimatedVectorDrawableOrNull(it);
            } else {
                animatedVectorDrawable = null;
            }
        } else if (compoundButton instanceof Switch) {
            Drawable drawable = ((Switch)compoundButton).getThumbDrawable();
            if (drawable != null) {
                Drawable it = drawable;
                boolean bl = false;
                animatedVectorDrawable = CompoundUtilsKt.getAnimatedVectorDrawableOrNull(it);
            } else {
                animatedVectorDrawable = null;
            }
        } else {
            animatedVectorDrawable = null;
        }
        return animatedVectorDrawable;
    }

    private static final AnimatedVectorDrawable getAnimatedVectorDrawableOrNull(Drawable drawable) {
        AnimatedVectorDrawable animatedVectorDrawable;
        if (drawable instanceof StateListDrawable) {
            Drawable drawable2 = ((StateListDrawable)drawable).getCurrent();
            Intrinsics.checkNotNullExpressionValue((Object)drawable2, (String)"getCurrent(...)");
            Drawable animatedDrawable = drawable2;
            animatedVectorDrawable = animatedDrawable instanceof AnimatedVectorDrawable ? (AnimatedVectorDrawable)animatedDrawable : null;
        } else {
            animatedVectorDrawable = null;
        }
        return animatedVectorDrawable;
    }

    public static final void registerAnimatedDrawableListener(@NotNull CompoundButton $this$registerAnimatedDrawableListener, @NotNull AnimatedVectorDrawable drawable, @NotNull AnimationEnd listener) {
        Intrinsics.checkNotNullParameter((Object)$this$registerAnimatedDrawableListener, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (CompoundUtilsKt.isAndroid24OrGreater()) {
            AnimatedVectorDrawable animatedDrawable = drawable;
            animatedDrawable.registerAnimationCallback(new Animatable2.AnimationCallback(listener){
                final /* synthetic */ AnimationEnd $listener;
                {
                    this.$listener = $listener;
                }

                public void onAnimationEnd(@NotNull Drawable drawable) {
                    Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
                    super.onAnimationEnd(drawable);
                    this.$listener.onAnimationEnd();
                }
            });
        }
    }

    @SuppressLint(value={"AnnotateVersionCheck"})
    private static final boolean isAndroid24OrGreater() {
        return Build.VERSION.SDK_INT >= 24;
    }
}

