/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound;

import android.graphics.drawable.AnimatedVectorDrawable;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.EspressoTrackingIdlingResource;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.AnimationEnd;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.CompoundUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.RadioGroupInterceptor;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.RadioGroupInterceptorImpl;
import com.dynatrace.android.sessionreplay.tracking.validator.CompoundValidation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/RadioGroupInterceptorImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/RadioGroupInterceptor;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/CompoundValidation;", "Landroid/view/View;", "trackingHandler", "Lkotlin/Function3;", "", "", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/CompoundValidation;Lkotlin/jvm/functions/Function3;)V", "interceptView", "radioGroup", "Landroid/widget/RadioGroup;", "listener", "Landroid/widget/RadioGroup$OnCheckedChangeListener;", "Companion", "OnCheckedChangedListener", "trackinglayer_release"})
public final class RadioGroupInterceptorImpl
implements RadioGroupInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundValidation<View> maskingValidator;
    @NotNull
    private final Function3<View, Boolean, Boolean, Unit> trackingHandler;
    private static final long DELAY_RADIO_GROUP = 150L;

    public RadioGroupInterceptorImpl(@NotNull CompoundValidation<View> maskingValidator, @NotNull Function3<? super View, ? super Boolean, ? super Boolean, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(maskingValidator, (String)"maskingValidator");
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.maskingValidator = maskingValidator;
        this.trackingHandler = trackingHandler;
    }

    @Override
    public void interceptView(@Nullable RadioGroup radioGroup, @Nullable RadioGroup.OnCheckedChangeListener listener) {
        RadioGroup radioGroup2 = radioGroup;
        Integer id = radioGroup2 != null ? Integer.valueOf(radioGroup2.getId()) : null;
        DTLogger.INSTANCE.tracking("interceptView: RadioGroup " + id);
        RadioGroup radioGroup3 = radioGroup;
        Intrinsics.checkNotNull((Object)radioGroup3);
        radioGroup3.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)new OnCheckedChangedListener(listener));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/RadioGroupInterceptorImpl$Companion;", "", "()V", "DELAY_RADIO_GROUP", "", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\r"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/RadioGroupInterceptorImpl$OnCheckedChangedListener;", "Landroid/widget/RadioGroup$OnCheckedChangeListener;", "listener", "(Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/RadioGroupInterceptorImpl;Landroid/widget/RadioGroup$OnCheckedChangeListener;)V", "getListener", "()Landroid/widget/RadioGroup$OnCheckedChangeListener;", "onCheckedChanged", "", "group", "Landroid/widget/RadioGroup;", "checkedId", "", "trackCheckedChanged", "trackinglayer_release"})
    private final class OnCheckedChangedListener
    implements RadioGroup.OnCheckedChangeListener {
        @Nullable
        private final RadioGroup.OnCheckedChangeListener listener;

        public OnCheckedChangedListener(RadioGroup.OnCheckedChangeListener listener) {
            this.listener = listener;
        }

        @Nullable
        public final RadioGroup.OnCheckedChangeListener getListener() {
            return this.listener;
        }

        public void onCheckedChanged(@NotNull RadioGroup group, int checkedId) {
            block2: {
                AnimatedVectorDrawable drawable;
                RadioButton compoundButton;
                Intrinsics.checkNotNullParameter((Object)group, (String)"group");
                EspressoTrackingIdlingResource.INSTANCE.increment();
                RadioButton radioButton = compoundButton = checkedId == -1 ? null : (RadioButton)group.findViewById(checkedId);
                AnimatedVectorDrawable animatedVectorDrawable = drawable = radioButton != null ? CompoundUtilsKt.getCustomButtonDrawable((CompoundButton)radioButton, (CompoundButton)compoundButton) : null;
                if (drawable != null) {
                    CompoundUtilsKt.registerAnimatedDrawableListener((CompoundButton)compoundButton, drawable, new AnimationEnd(compoundButton, this, group, checkedId){
                        final /* synthetic */ RadioButton $compoundButton;
                        final /* synthetic */ OnCheckedChangedListener this$0;
                        final /* synthetic */ RadioGroup $group;
                        final /* synthetic */ int $checkedId;
                        {
                            this.$compoundButton = $compoundButton;
                            this.this$0 = $receiver;
                            this.$group = $group;
                            this.$checkedId = $checkedId;
                        }

                        public void onAnimationEnd() {
                            this.$compoundButton.post(() -> onCheckedChanged.1.onAnimationEnd$lambda$0(this.this$0, this.$group, this.$checkedId));
                        }

                        private static final void onAnimationEnd$lambda$0(OnCheckedChangedListener this$0, RadioGroup $group, int $checkedId) {
                            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                            Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
                            this$0.trackCheckedChanged($group, $checkedId);
                            EspressoTrackingIdlingResource.INSTANCE.decrement();
                        }
                    });
                } else {
                    RadioButton radioButton2 = compoundButton;
                    View animatedView = radioButton2 != null ? (View)radioButton2 : (View)group;
                    animatedView.postOnAnimationDelayed(() -> OnCheckedChangedListener.onCheckedChanged$lambda$0(this, group, checkedId), 150L);
                }
                RadioGroup.OnCheckedChangeListener onCheckedChangeListener = this.listener;
                if (onCheckedChangeListener == null) break block2;
                onCheckedChangeListener.onCheckedChanged(group, checkedId);
            }
        }

        public final void trackCheckedChanged(@NotNull RadioGroup group, int checkedId) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            int id = group.getId();
            boolean isCheckedReset = checkedId == -1;
            DTLogger.INSTANCE.tracking("RadioGroup with id: " + id + (isCheckedReset ? " has state reset" : " has a RadioButton with id: " + checkedId + " selected"));
            boolean isMasked = RadioGroupInterceptorImpl.this.maskingValidator.validate(group);
            RadioGroupInterceptorImpl.this.trackingHandler.invoke((Object)group, (Object)(!isCheckedReset ? 1 : 0), (Object)isMasked);
        }

        private static final void onCheckedChanged$lambda$0(OnCheckedChangedListener this$0, RadioGroup $group, int $checkedId) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$group, (String)"$group");
            this$0.trackCheckedChanged($group, $checkedId);
            EspressoTrackingIdlingResource.INSTANCE.decrement();
        }
    }
}

