/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.BitmapSize;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugBitmapHelper;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugOverlay;
import com.dynatrace.android.sessionreplay.tracking.helpers.DividedRectangles;
import com.dynatrace.android.sessionreplay.tracking.helpers.OcclusionHandler;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandlerUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskingHandler;
import com.dynatrace.android.sessionreplay.tracking.utils.ViewExtensionKt;
import com.dynatrace.android.sessionreplay.tracking.validator.screenshot.ScreenshotValidator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/NativeScreenshotHandler;", "", "screenshotValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/screenshot/ScreenshotValidator;", "occlusionHandler", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "maskingHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;", "Landroid/view/View;", "composeMaskingHandler", "", "Landroid/graphics/Rect;", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedAreas;", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/screenshot/ScreenshotValidator;Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;)V", "composeMaskedAreas", "drawPartialBitmapUnCropped", "Landroid/graphics/Bitmap;", "rootBitmap", "viewRect", "getPartialBitmap", "view", "getPartialBitmapUnCropped", "getRootBitmap", "takeFullScreenshot", "takePartialScreenshot", "takeScreenshot", "uiView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackinglayer_release"})
public final class NativeScreenshotHandler {
    @NotNull
    private final ScreenshotValidator screenshotValidator;
    @NotNull
    private final OcclusionHandler occlusionHandler;
    @NotNull
    private final MaskingHandler<View> maskingHandler;
    @NotNull
    private final MaskingHandler<List<Rect>> composeMaskingHandler;
    @NotNull
    private List<Rect> composeMaskedAreas;

    public NativeScreenshotHandler(@NotNull ScreenshotValidator screenshotValidator, @NotNull OcclusionHandler occlusionHandler, @NotNull MaskingHandler<View> maskingHandler, @NotNull MaskingHandler<List<Rect>> composeMaskingHandler) {
        Intrinsics.checkNotNullParameter((Object)screenshotValidator, (String)"screenshotValidator");
        Intrinsics.checkNotNullParameter((Object)occlusionHandler, (String)"occlusionHandler");
        Intrinsics.checkNotNullParameter(maskingHandler, (String)"maskingHandler");
        Intrinsics.checkNotNullParameter(composeMaskingHandler, (String)"composeMaskingHandler");
        this.screenshotValidator = screenshotValidator;
        this.occlusionHandler = occlusionHandler;
        this.maskingHandler = maskingHandler;
        this.composeMaskingHandler = composeMaskingHandler;
        this.composeMaskedAreas = CollectionsKt.emptyList();
    }

    @Nullable
    public final Bitmap takeScreenshot(@NotNull UIView uiView) {
        Intrinsics.checkNotNullParameter((Object)uiView, (String)"uiView");
        this.composeMaskedAreas = CollectionsKt.toList((Iterable)uiView.getMaskedAreas());
        View view = uiView.getContainerView();
        if (view == null || view.getWidth() <= 0 || view.getHeight() <= 0) {
            View view2 = view;
            View view3 = view;
            DTLogger.INSTANCE.tracking("Record: no view or no size with view=" + view + " and " + (view2 != null ? Integer.valueOf(view2.getWidth()) : null) + 'x' + (view3 != null ? Integer.valueOf(view3.getHeight()) : null));
            return null;
        }
        View view4 = uiView.getContainerView();
        Bitmap bitmap = Intrinsics.areEqual((Object)uiView.getContainerView(), (Object)(view4 != null ? view4.getRootView() : null)) ? this.takeFullScreenshot(view) : this.takePartialScreenshot(view);
        DebugBitmapHelper.INSTANCE.saveBitmap$trackinglayer_release(view, bitmap);
        DebugOverlay.INSTANCE.showDebugOverlay(uiView, bitmap);
        return bitmap;
    }

    private final Bitmap takeFullScreenshot(View view) {
        View view2 = view.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        this.occlusionHandler.updateViews(view2);
        return this.getRootBitmap(view);
    }

    private final Bitmap takePartialScreenshot(View view) {
        if (!this.screenshotValidator.validate(view)) {
            DTLogger.INSTANCE.info("Track: partial screenshot will be null");
            return null;
        }
        return this.getPartialBitmap(view);
    }

    private final Bitmap getRootBitmap(View view) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap rootBitmap = bitmap;
        Canvas rootCanvas = new Canvas(rootBitmap);
        try {
            view.draw(rootCanvas);
        }
        catch (Exception e) {
            DTLogger.INSTANCE.error("Screenshot: Is not possible to get a screenshot: " + e.getLocalizedMessage());
        }
        this.maskingHandler.mask(view, rootCanvas);
        if (!((Collection)ViewExtensionKt.findComposeViews(view)).isEmpty()) {
            this.composeMaskingHandler.mask(this.composeMaskedAreas, rootCanvas);
        }
        return rootBitmap;
    }

    private final Bitmap getPartialBitmap(View view) {
        Pair<DividedRectangles, Rect> viewFrames = this.occlusionHandler.getViewFrames(view);
        Set<Rect> viewVisibleRects = ((DividedRectangles)viewFrames.getFirst()).getRectangles();
        Rect viewRect = (Rect)viewFrames.getSecond();
        Bitmap bitmap = this.getPartialBitmapUnCropped(view, viewRect);
        if (bitmap == null) {
            return null;
        }
        Bitmap viewBitmap = bitmap;
        Bitmap bitmap2 = Bitmap.createBitmap((int)viewRect.width(), (int)viewRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        Bitmap finalPartialBitmap = bitmap2;
        Canvas canvas = new Canvas(finalPartialBitmap);
        for (Rect visibleRect : viewVisibleRects) {
            BitmapSize bitmapSize = BitmapSize.Companion.from(visibleRect, viewRect, finalPartialBitmap, viewBitmap);
            if (bitmapSize.getWidth() <= 0 || bitmapSize.getHeight() <= 0) {
                DTLogger.INSTANCE.tracking("Record: invalid size " + bitmapSize.getWidth() + 'x' + bitmapSize.getHeight());
                continue;
            }
            try {
                Bitmap createBitmap;
                Intrinsics.checkNotNullExpressionValue((Object)Bitmap.createBitmap((Bitmap)viewBitmap, (int)bitmapSize.getX(), (int)bitmapSize.getY(), (int)bitmapSize.getWidth(), (int)bitmapSize.getHeight()), (String)"createBitmap(...)");
                canvas.drawBitmap(createBitmap, (float)bitmapSize.getX(), (float)bitmapSize.getY(), null);
            }
            catch (Exception e) {
                DTLogger.INSTANCE.error(ExceptionsKt.stackTraceToString((Throwable)e));
            }
        }
        return finalPartialBitmap;
    }

    private final Bitmap getPartialBitmapUnCropped(View view, Rect viewRect) {
        View view2 = view.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        Bitmap rootBitmap = this.getRootBitmap(view2);
        return this.drawPartialBitmapUnCropped(rootBitmap, viewRect);
    }

    private final Bitmap drawPartialBitmapUnCropped(Bitmap rootBitmap, Rect viewRect) {
        Pair<Integer, Integer> pair = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewRect.left, viewRect.right - viewRect.left, rootBitmap.getWidth());
        int x = ((Number)pair.component1()).intValue();
        int width = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewRect.top, viewRect.bottom - viewRect.top, rootBitmap.getHeight());
        int y = ((Number)pair2.component1()).intValue();
        int height = ((Number)pair2.component2()).intValue();
        if (width <= 0 || height <= 0) {
            DTLogger.INSTANCE.tracking("Record: invalid size " + width + 'x' + height);
            return null;
        }
        return Bitmap.createBitmap((Bitmap)rootBitmap, (int)x, (int)y, (int)width, (int)height);
    }
}

