/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugBitmapHelper;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugOverlay;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandlerUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskingHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J3\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132#\u0010\u0014\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\n\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00110\u0015R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/PixelCopyComposeScreenshotHandler;", "", "composeMaskingHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;", "", "Landroid/graphics/Rect;", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedAreas;", "(Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;)V", "composeMaskedRects", "drawPartialBitmapUnCropped", "Landroid/graphics/Bitmap;", "rootBitmap", "viewMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/ViewMetadata;", "mask", "bitmap", "takeScreenshot", "", "uiComposeView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIComposeView;", "function", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "trackinglayer_release"})
@RequiresApi(value=26)
public final class PixelCopyComposeScreenshotHandler {
    @NotNull
    private final MaskingHandler<List<Rect>> composeMaskingHandler;
    @NotNull
    private List<Rect> composeMaskedRects;

    public PixelCopyComposeScreenshotHandler(@NotNull MaskingHandler<List<Rect>> composeMaskingHandler) {
        Intrinsics.checkNotNullParameter(composeMaskingHandler, (String)"composeMaskingHandler");
        this.composeMaskingHandler = composeMaskingHandler;
        this.composeMaskedRects = CollectionsKt.emptyList();
    }

    public final void takeScreenshot(@NotNull UIComposeView uiComposeView, @NotNull Function1<? super Bitmap, Unit> function) {
        Intrinsics.checkNotNullParameter((Object)uiComposeView, (String)"uiComposeView");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.composeMaskedRects = CollectionsKt.toList((Iterable)uiComposeView.getMaskedAreas());
        View view = uiComposeView.getContainerView();
        ViewMetadata viewMetadata = uiComposeView.getMetadata();
        if (view == null) {
            DTLogger.INSTANCE.tracking("Record: no view found");
            return;
        }
        if (view.getWidth() <= 0 || view.getHeight() <= 0) {
            DTLogger.INSTANCE.tracking("Record: incorrect view size with view=" + view + " and " + view.getWidth() + 'x' + view.getHeight());
            return;
        }
        view.post(() -> PixelCopyComposeScreenshotHandler.takeScreenshot$lambda$1(view, uiComposeView, this, viewMetadata, function));
    }

    private final Bitmap mask(Bitmap bitmap) {
        Canvas rootCanvas = new Canvas(bitmap);
        this.composeMaskingHandler.mask(this.composeMaskedRects, rootCanvas);
        return bitmap;
    }

    private final Bitmap drawPartialBitmapUnCropped(Bitmap rootBitmap, ViewMetadata viewMetadata) {
        Pair<Integer, Integer> pair = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewMetadata.getPositionX(), viewMetadata.getViewWidth(), rootBitmap.getWidth());
        int x = ((Number)pair.component1()).intValue();
        int width = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewMetadata.getPositionY(), viewMetadata.getViewHeight(), rootBitmap.getHeight());
        int y = ((Number)pair2.component1()).intValue();
        int height = ((Number)pair2.component2()).intValue();
        if (width <= 0 || height <= 0) {
            DTLogger.INSTANCE.tracking("Record: invalid size " + width + 'x' + height);
            return null;
        }
        return Bitmap.createBitmap((Bitmap)rootBitmap, (int)x, (int)y, (int)width, (int)height);
    }

    private static final void takeScreenshot$lambda$1$lambda$0(PixelCopyComposeScreenshotHandler this$0, Bitmap $rootBitmap, ViewMetadata $viewMetadata, View $view, UIComposeView $uiComposeView, Function1 $function, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootBitmap, (String)"$rootBitmap");
        Intrinsics.checkNotNullParameter((Object)$viewMetadata, (String)"$viewMetadata");
        Intrinsics.checkNotNullParameter((Object)$uiComposeView, (String)"$uiComposeView");
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        DTLogger.INSTANCE.info("PixelCopy Screenshot finished");
        Bitmap maskedBitmap = this$0.mask($rootBitmap);
        Bitmap bitmap = this$0.drawPartialBitmapUnCropped(maskedBitmap, $viewMetadata);
        DebugBitmapHelper.INSTANCE.saveBitmap$trackinglayer_release($view, bitmap);
        DebugOverlay.INSTANCE.showDebugOverlay($uiComposeView, bitmap);
        $function.invoke((Object)bitmap);
    }

    private static final void takeScreenshot$lambda$1(View $view, UIComposeView $uiComposeView, PixelCopyComposeScreenshotHandler this$0, ViewMetadata $viewMetadata, Function1 $function) {
        Intrinsics.checkNotNullParameter((Object)$uiComposeView, (String)"$uiComposeView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$viewMetadata, (String)"$viewMetadata");
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)$view.getWidth(), (int)$view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap rootBitmap = bitmap;
            Window window = $uiComposeView.getContainerWindow();
            if (window == null) {
                window = ScreenshotHandlerUtilsKt.getWindow($view);
            }
            Window window2 = window;
            PixelCopy.request((Window)window2, null, (Bitmap)rootBitmap, arg_0 -> PixelCopyComposeScreenshotHandler.takeScreenshot$lambda$1$lambda$0(this$0, rootBitmap, $viewMetadata, $view, $uiComposeView, $function, arg_0), (Handler)$view.getHandler());
        }
        catch (Exception ex) {
            DTLogger.INSTANCE.error("Error trying to get root bitmap: " + ex);
        }
    }
}

