/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot.masking;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.dynatrace.android.sessionreplay.tracking.helpers.DividedRectangles;
import com.dynatrace.android.sessionreplay.tracking.helpers.OcclusionHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0004H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/NativeMaskingAreasProvider;", "", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;", "Landroid/view/View;", "occlusionHandler", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;)V", "getMaskedAreas", "", "Landroid/graphics/Rect;", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedAreas;", "view", "isMasked", "", "needMasking", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nNativeMaskingAreasProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeMaskingAreasProvider.kt\ncom/dynatrace/android/sessionreplay/tracking/screenshot/masking/NativeMaskingAreasProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n2624#2,3:53\n*S KotlinDebug\n*F\n+ 1 NativeMaskingAreasProvider.kt\ncom/dynatrace/android/sessionreplay/tracking/screenshot/masking/NativeMaskingAreasProvider\n*L\n46#1:53,3\n*E\n"})
public final class NativeMaskingAreasProvider {
    @NotNull
    private final Validation<View> maskingValidator;
    @NotNull
    private final OcclusionHandler occlusionHandler;

    public NativeMaskingAreasProvider(@NotNull Validation<? super View> maskingValidator, @NotNull OcclusionHandler occlusionHandler) {
        Intrinsics.checkNotNullParameter(maskingValidator, (String)"maskingValidator");
        Intrinsics.checkNotNullParameter((Object)occlusionHandler, (String)"occlusionHandler");
        this.maskingValidator = maskingValidator;
        this.occlusionHandler = occlusionHandler;
    }

    @NotNull
    public final List<Rect> getMaskedAreas(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.needMasking(view)) {
            return CollectionsKt.emptyList();
        }
        List maskedAreas = new ArrayList();
        if (this.isMasked(view)) {
            if (view.getVisibility() != 0) {
                return maskedAreas;
            }
            DividedRectangles frames = this.occlusionHandler.getVisibleFrames(view);
            maskedAreas.addAll((Collection)frames.getRectangles());
        } else if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int index = 0; index < n; ++index) {
                Collection collection = maskedAreas;
                View view2 = ((ViewGroup)view).getChildAt(index);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)this.getMaskedAreas(view2));
            }
        }
        return maskedAreas;
    }

    private final boolean isMasked(View view) {
        return this.maskingValidator.validate(view);
    }

    private final boolean needMasking(View $this$needMasking) {
        return true;
    }
}

