/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.listeners.UIState;
import com.dynatrace.android.sessionreplay.tracking.model.CustomMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/CustomEventTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "uiState", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;)V", "logNoActivityFound", "", "trackCustomArea", "name", "", "area", "Landroid/graphics/Rect;", "trackCustomFull", "trackCustomPartial", "view", "Landroid/view/View;", "trackView", "uiView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackinglayer_release"})
public final class CustomEventTracker {
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final UIState uiState;
    @NotNull
    private final ScreenshotHandler screenshotHandler;

    public CustomEventTracker(@NotNull TrackingObserver trackingObserver, @NotNull UIState uiState, @NotNull ScreenshotHandler screenshotHandler) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        this.trackingObserver = trackingObserver;
        this.uiState = uiState;
        this.screenshotHandler = screenshotHandler;
    }

    public final void trackCustomFull(@NotNull String name) {
        block2: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            UIView uIView = this.uiState.getCurrentView();
            if (uIView != null) {
                UIView fullUIView = uIView;
                boolean bl = false;
                this.trackView(name, fullUIView);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block2;
            CustomEventTracker $this$trackCustomFull_u24lambda_u241 = this;
            boolean bl = false;
            $this$trackCustomFull_u24lambda_u241.logNoActivityFound();
        }
    }

    public final void trackCustomPartial(@NotNull String name, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.trackView(name, new UIView(view, null, null, 6, null));
    }

    public final void trackCustomArea(@NotNull String name, @NotNull Rect area) {
        block3: {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)area, (String)"area");
            UIView uIView = this.uiState.getCurrentView();
            if (uIView != null) {
                UIView fullUIView = uIView;
                boolean bl = false;
                ViewMetadata viewMetadata = fullUIView.getMetadata();
                if (viewMetadata == null) {
                    CustomEventTracker $this$trackCustomArea_u24lambda_u243_u24lambda_u242 = this;
                    boolean bl2 = false;
                    $this$trackCustomArea_u24lambda_u243_u24lambda_u242.logNoActivityFound();
                    return;
                }
                ViewMetadata viewMetadata2 = viewMetadata;
                this.screenshotHandler.takeAreaScreenshot(fullUIView, area, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, name, viewMetadata2){
                    final /* synthetic */ CustomEventTracker this$0;
                    final /* synthetic */ String $name;
                    final /* synthetic */ ViewMetadata $viewMetadata;
                    {
                        this.this$0 = $receiver;
                        this.$name = $name;
                        this.$viewMetadata = $viewMetadata;
                        super(1);
                    }

                    public final void invoke(@Nullable Bitmap bitmap) {
                        TrackingObserver trackingObserver = CustomEventTracker.access$getTrackingObserver$p(this.this$0);
                        Date date = new Date();
                        CustomMetadata customMetadata = new CustomMetadata(this.$name);
                        trackingObserver.onCustom(date, this.$viewMetadata, false, customMetadata, bitmap);
                    }
                }));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            CustomEventTracker $this$trackCustomArea_u24lambda_u244 = this;
            boolean bl = false;
            $this$trackCustomArea_u24lambda_u244.logNoActivityFound();
        }
    }

    private final void trackView(String name, UIView uiView) {
        ViewMetadata viewMetadata = uiView.getMetadata();
        if (viewMetadata == null) {
            return;
        }
        ViewMetadata viewMetadata2 = viewMetadata;
        this.screenshotHandler.takeScreenshot(uiView, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, name, viewMetadata2){
            final /* synthetic */ CustomEventTracker this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ ViewMetadata $viewMetadata;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$viewMetadata = $viewMetadata;
                super(1);
            }

            public final void invoke(@Nullable Bitmap bitmap) {
                TrackingObserver trackingObserver = CustomEventTracker.access$getTrackingObserver$p(this.this$0);
                Date date = new Date();
                CustomMetadata customMetadata = new CustomMetadata(this.$name);
                trackingObserver.onCustom(date, this.$viewMetadata, false, customMetadata, bitmap);
            }
        }));
    }

    private final void logNoActivityFound() {
        DTLogger.INSTANCE.error("Error trying to track a custom event -> no activity found");
    }

    public static final /* synthetic */ TrackingObserver access$getTrackingObserver$p(CustomEventTracker $this) {
        return $this.trackingObserver;
    }
}

