/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.app.Activity;
import android.graphics.Bitmap;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.listeners.UIState;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.utils.ActivityUtilsKt;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/GenericEventTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "uiState", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;)V", "getActivityUIView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackEvent", "", "name", "", "viewMetadata", "Lcom/dynatrace/android/sessionreplay/tracking/model/ViewMetadata;", "bitmap", "Landroid/graphics/Bitmap;", "trackGenericEvent", "withScreenshot", "", "trackinglayer_release"})
public final class GenericEventTracker {
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final UIState uiState;
    @NotNull
    private final ScreenshotHandler screenshotHandler;

    public GenericEventTracker(@NotNull TrackingObserver trackingObserver, @NotNull UIState uiState, @NotNull ScreenshotHandler screenshotHandler) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        this.trackingObserver = trackingObserver;
        this.uiState = uiState;
        this.screenshotHandler = screenshotHandler;
    }

    public final void trackGenericEvent(@NotNull String name, boolean withScreenshot) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UIView uIView = this.getActivityUIView();
        if (uIView == null) {
            return;
        }
        UIView fullUIView = uIView;
        Object object = fullUIView.getView$trackinglayer_release();
        if (object == null || (object = ViewExtensionsKt.getMetadata(object)) == null) {
            return;
        }
        Object viewMetadata = object;
        if (withScreenshot) {
            this.screenshotHandler.takeScreenshot(fullUIView, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, name, (ViewMetadata)viewMetadata){
                final /* synthetic */ GenericEventTracker this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ ViewMetadata $viewMetadata;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    this.$viewMetadata = $viewMetadata;
                    super(1);
                }

                public final void invoke(@Nullable Bitmap bitmap) {
                    GenericEventTracker.access$trackEvent(this.this$0, this.$name, this.$viewMetadata, bitmap);
                }
            }));
        } else {
            this.trackEvent(name, (ViewMetadata)viewMetadata, null);
        }
    }

    public static /* synthetic */ void trackGenericEvent$default(GenericEventTracker genericEventTracker, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        genericEventTracker.trackGenericEvent(string, bl);
    }

    private final UIView getActivityUIView() {
        UIView uIView;
        UIView uIView2 = this.uiState.getCurrentView();
        if ((uIView2 != null ? uIView2.getView$trackinglayer_release() : null) == null) {
            DTLogger.INSTANCE.warning("Generic Event: No activity provided by ActivityLifecycleCallbacks");
            Activity activity = ActivityUtilsKt.getRunningActivityByReflection();
            if (activity != null) {
                Activity it = activity;
                boolean bl = false;
                uIView = new UIView(it.getWindow().getDecorView(), it.getWindow(), null, 4, null);
            } else {
                GenericEventTracker $this$getActivityUIView_u24lambda_u241 = this;
                boolean bl = false;
                DTLogger.INSTANCE.error("Generic Event: Unable to get activity by reflection");
                uIView = null;
            }
        } else {
            uIView = this.uiState.getCurrentView();
        }
        return uIView;
    }

    private final void trackEvent(String name, ViewMetadata viewMetadata, Bitmap bitmap) {
        this.trackingObserver.onGenericEvent(new Date(), name, viewMetadata, false, bitmap);
    }

    public static final /* synthetic */ void access$trackEvent(GenericEventTracker $this, String name, ViewMetadata viewMetadata, Bitmap bitmap) {
        $this.trackEvent(name, viewMetadata, bitmap);
    }
}

