/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.sessionreplay.tracking.extensions.StringExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.InputEndMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.InputStartMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.KeystrokeMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fJ*\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\fJ\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J:\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\f2\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/InputTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "currentInputStart", "Ljava/util/Date;", "currentModificationId", "", "isCurrentInputEventMasked", "", "isCurrentInputEventSecured", "addKeystroke", "", "currentView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "keystrokeValue", "endInput", "field", "name", "value", "processValue", "startInput", "viewHolder", "isSecured", "isMasked", "Companion", "trackinglayer_release"})
public final class InputTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;
    @Nullable
    private String currentModificationId;
    @Nullable
    private Date currentInputStart;
    private boolean isCurrentInputEventSecured;
    private boolean isCurrentInputEventMasked;
    @NotNull
    private static final String DEFAULT_NAME = "Unknown";
    @NotNull
    private static final String MASKED = "***";

    public InputTracker(@NotNull TrackingObserver trackingObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.trackingObserver = trackingObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void startInput(@NotNull UIView viewHolder, @Nullable String field, @Nullable String name, @NotNull String value, boolean isSecured, boolean isMasked) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.isCurrentInputEventSecured = isSecured;
            this.isCurrentInputEventMasked = isMasked;
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            Date date = new Date();
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = name;
            if (string2 == null) {
                string2 = DEFAULT_NAME;
            }
            InputStartMetadata startMetadata = new InputStartMetadata(string, string2, field, value);
            this.trackingObserver.onInputStart(date, viewMetadata, this.maskingValidator.validate(view2), startMetadata);
            this.currentModificationId = startMetadata.getInputModificationId();
            this.currentInputStart = date;
        }
    }

    public final void addKeystroke(@NotNull UIView currentView, @NotNull String keystrokeValue) {
        Intrinsics.checkNotNullParameter((Object)currentView, (String)"currentView");
        Intrinsics.checkNotNullParameter((Object)keystrokeValue, (String)"keystrokeValue");
        if (this.isCurrentInputEventSecured || this.currentModificationId == null) {
            return;
        }
        String finalValue = this.processValue(keystrokeValue);
        Function1 endCode2 = (Function1)new Function1<Bitmap, Unit>(this, currentView, finalValue){
            final /* synthetic */ InputTracker this$0;
            final /* synthetic */ UIView $currentView;
            final /* synthetic */ String $finalValue;
            {
                this.this$0 = $receiver;
                this.$currentView = $currentView;
                this.$finalValue = $finalValue;
                super(1);
            }

            public final void invoke(@Nullable Bitmap bitmap) {
                block1: {
                    String string = InputTracker.access$getCurrentModificationId$p(this.this$0);
                    if (string == null) break block1;
                    String string2 = string;
                    UIView uIView = this.$currentView;
                    InputTracker inputTracker = this.this$0;
                    String string3 = this.$finalValue;
                    String modificationId = string2;
                    boolean bl = false;
                    ViewMetadata viewMetadata = uIView.getMetadata();
                    if (viewMetadata != null) {
                        ViewMetadata viewMetadata2 = viewMetadata;
                        boolean bl2 = false;
                        TrackingObserver trackingObserver = InputTracker.access$getTrackingObserver$p(inputTracker);
                        Date date = new Date();
                        MaskingValidator maskingValidator = InputTracker.access$getMaskingValidator$p(inputTracker);
                        View view = uIView.getView$trackinglayer_release();
                        Intrinsics.checkNotNull((Object)view);
                        trackingObserver.onKeystroke(date, viewMetadata2, maskingValidator.validate(view), new KeystrokeMetadata(modificationId, string3), bitmap);
                    }
                }
            }
        };
        if (this.isCurrentInputEventMasked) {
            endCode2.invoke(null);
        } else {
            this.screenshotHandler.takeScreenshotDelayed(currentView, 10L, (Function1<? super Bitmap, Unit>)endCode2);
        }
    }

    public final void endInput(@NotNull UIView currentView, @Nullable String field, @Nullable String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)currentView, (String)"currentView");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String modificationId = this.currentModificationId;
        Date inputStartTime = this.currentInputStart;
        if (modificationId == null || inputStartTime == null) {
            this.currentModificationId = null;
            this.currentInputStart = null;
            return;
        }
        String finalValue = this.processValue(value);
        Function1 endCode2 = (Function1)new Function1<Bitmap, Unit>(currentView, modificationId, name, field, inputStartTime, finalValue, this){
            final /* synthetic */ UIView $currentView;
            final /* synthetic */ String $modificationId;
            final /* synthetic */ String $name;
            final /* synthetic */ String $field;
            final /* synthetic */ Date $inputStartTime;
            final /* synthetic */ String $finalValue;
            final /* synthetic */ InputTracker this$0;
            {
                this.$currentView = $currentView;
                this.$modificationId = $modificationId;
                this.$name = $name;
                this.$field = $field;
                this.$inputStartTime = $inputStartTime;
                this.$finalValue = $finalValue;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@Nullable Bitmap bitmap) {
                block1: {
                    ViewMetadata viewMetadata = this.$currentView.getMetadata();
                    if (viewMetadata == null) break block1;
                    ViewMetadata viewMetadata2 = viewMetadata;
                    String string = this.$modificationId;
                    String string2 = this.$name;
                    String string3 = this.$field;
                    Date date = this.$inputStartTime;
                    String string4 = this.$finalValue;
                    InputTracker inputTracker = this.this$0;
                    UIView uIView = this.$currentView;
                    ViewMetadata viewMetadata3 = viewMetadata2;
                    boolean bl = false;
                    Date endTime = new Date();
                    String string5 = string2;
                    if (string5 == null) {
                        string5 = "Unknown";
                    }
                    InputEndMetadata inputEndMetadata = new InputEndMetadata(string, string5, string3, endTime.getTime() - date.getTime(), string4);
                    TrackingObserver trackingObserver = InputTracker.access$getTrackingObserver$p(inputTracker);
                    MaskingValidator maskingValidator = InputTracker.access$getMaskingValidator$p(inputTracker);
                    View view = uIView.getView$trackinglayer_release();
                    Intrinsics.checkNotNull((Object)view);
                    trackingObserver.onInputEnd(endTime, viewMetadata3, maskingValidator.validate(view), inputEndMetadata, bitmap);
                }
            }
        };
        if (!this.isCurrentInputEventMasked && !this.isCurrentInputEventSecured) {
            this.screenshotHandler.takeScreenshot(currentView, (Function1<? super Bitmap, Unit>)endCode2);
        } else {
            endCode2.invoke(null);
        }
        this.currentModificationId = null;
        this.currentInputStart = null;
    }

    private final String processValue(String value) {
        return this.isCurrentInputEventSecured ? MASKED : (this.isCurrentInputEventMasked ? StringExtensionsKt.mask(value) : value);
    }

    public static final /* synthetic */ String access$getCurrentModificationId$p(InputTracker $this) {
        return $this.currentModificationId;
    }

    public static final /* synthetic */ TrackingObserver access$getTrackingObserver$p(InputTracker $this) {
        return $this.trackingObserver;
    }

    public static final /* synthetic */ MaskingValidator access$getMaskingValidator$p(InputTracker $this) {
        return $this.maskingValidator;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/InputTracker$Companion;", "", "()V", "DEFAULT_NAME", "", "MASKED", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

