/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.KeyboardMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.ScreenObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ.\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/KeyboardTracker;", "", "screenObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/ScreenObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/ScreenObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "trackKeyboardHidden", "", "view", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackKeyboardShown", "viewHolder", "x", "", "y", "width", "height", "trackinglayer_release"})
public final class KeyboardTracker {
    @NotNull
    private final ScreenObserver screenObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public KeyboardTracker(@NotNull ScreenObserver screenObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)screenObserver, (String)"screenObserver");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.screenObserver = screenObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackKeyboardShown(@NotNull UIView viewHolder, int x, int y, int width, int height) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) break block0;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            this.screenshotHandler.takeScreenshot(viewHolder, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, viewMetadata, view2, x, y, width, height){
                final /* synthetic */ KeyboardTracker this$0;
                final /* synthetic */ ViewMetadata $viewMetadata;
                final /* synthetic */ View $view;
                final /* synthetic */ int $x;
                final /* synthetic */ int $y;
                final /* synthetic */ int $width;
                final /* synthetic */ int $height;
                {
                    this.this$0 = $receiver;
                    this.$viewMetadata = $viewMetadata;
                    this.$view = $view;
                    this.$x = $x;
                    this.$y = $y;
                    this.$width = $width;
                    this.$height = $height;
                    super(1);
                }

                public final void invoke(@Nullable Bitmap bitmap) {
                    KeyboardTracker.access$getScreenObserver$p(this.this$0).onKeyboardChange(new Date(), this.$viewMetadata, KeyboardTracker.access$getMaskingValidator$p(this.this$0).validate(this.$view), new KeyboardMetadata(true, this.$x, this.$y, this.$width, this.$height), bitmap);
                }
            }));
        }
    }

    public final void trackKeyboardHidden(@NotNull UIView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ViewMetadata viewMetadata = view.getMetadata();
        if (viewMetadata == null) {
            return;
        }
        ViewMetadata metadata = viewMetadata;
        this.screenshotHandler.takeScreenshot(view, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, metadata, view){
            final /* synthetic */ KeyboardTracker this$0;
            final /* synthetic */ ViewMetadata $metadata;
            final /* synthetic */ UIView $view;
            {
                this.this$0 = $receiver;
                this.$metadata = $metadata;
                this.$view = $view;
                super(1);
            }

            public final void invoke(@Nullable Bitmap bitmap) {
                ScreenObserver screenObserver = KeyboardTracker.access$getScreenObserver$p(this.this$0);
                Date date = new Date();
                MaskingValidator maskingValidator = KeyboardTracker.access$getMaskingValidator$p(this.this$0);
                View view = this.$view.getView$trackinglayer_release();
                Intrinsics.checkNotNull((Object)view);
                screenObserver.onKeyboardChange(date, this.$metadata, maskingValidator.validate(view), new KeyboardMetadata(false, 0, 0, 0, 0, 30, null), bitmap);
            }
        }));
    }

    public static final /* synthetic */ ScreenObserver access$getScreenObserver$p(KeyboardTracker $this) {
        return $this.screenObserver;
    }

    public static final /* synthetic */ MaskingValidator access$getMaskingValidator$p(KeyboardTracker $this) {
        return $this.maskingValidator;
    }
}

