/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.app.Activity;
import com.dynatrace.android.sessionreplay.tracking.listeners.UIState;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.utils.ActivityIdentity;
import java.util.Date;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\t\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\nj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/LifecycleTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "uiState", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;", "activityIdentity", "Lcom/dynatrace/android/sessionreplay/tracking/utils/ActivityIdentity;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;Lcom/dynatrace/android/sessionreplay/tracking/utils/ActivityIdentity;)V", "appActivities", "Ljava/util/HashSet;", "Lkotlin/Pair;", "", "", "Lkotlin/collections/HashSet;", "changingConfiguration", "", "onActivityPaused", "", "activity", "Landroid/app/Activity;", "onActivityStarted", "onActivityStopped", "trackinglayer_release"})
public final class LifecycleTracker {
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final UIState uiState;
    @NotNull
    private final ActivityIdentity activityIdentity;
    private boolean changingConfiguration;
    @NotNull
    private final HashSet<Pair<String, Integer>> appActivities;

    public LifecycleTracker(@NotNull TrackingObserver trackingObserver, @NotNull UIState uiState, @NotNull ActivityIdentity activityIdentity) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)activityIdentity, (String)"activityIdentity");
        this.trackingObserver = trackingObserver;
        this.uiState = uiState;
        this.activityIdentity = activityIdentity;
        this.appActivities = new HashSet();
    }

    public /* synthetic */ LifecycleTracker(TrackingObserver trackingObserver, UIState uIState, ActivityIdentity activityIdentity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            activityIdentity = ActivityIdentity.INSTANCE;
        }
        this(trackingObserver, uIState, activityIdentity);
    }

    public final void onActivityStarted(@NotNull Activity activity) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            int previousSize = this.appActivities.size();
            this.appActivities.add(this.activityIdentity.activityInfoPair(activity));
            if (previousSize == this.appActivities.size() || this.appActivities.size() != 1 || this.changingConfiguration) break block1;
            if (this.uiState.getCurrentView() != null) {
                boolean bl = false;
                this.trackingObserver.onForeground(new Date());
            }
        }
    }

    public final void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.appActivities.add(this.activityIdentity.activityInfoPair(activity));
    }

    public final void onActivityStopped(@NotNull Activity activity) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            this.changingConfiguration = activity.isChangingConfigurations();
            this.appActivities.remove(this.activityIdentity.activityInfoPair(activity));
            if (this.appActivities.size() != 0 || this.changingConfiguration) break block1;
            if (this.uiState.getCurrentView() != null) {
                boolean bl = false;
                this.trackingObserver.onBackground(new Date());
            }
        }
    }
}

