/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers.compose;

import android.graphics.Bitmap;
import android.view.View;
import android.view.Window;
import androidx.compose.ui.layout.LayoutCoordinates;
import com.dynatrace.android.sessionreplay.tracking.model.InputEndMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.InputStartMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.KeystrokeMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadataKt;
import com.dynatrace.android.sessionreplay.tracking.observer.InputObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.trackers.compose.InputTracker;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J*\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/InputTrackerImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/InputTracker;", "inputObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/InputObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/InputObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;)V", "focusStartTimestamp", "", "id", "", "addKeystroke", "", "text", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "endInput", "startInput", "Companion", "trackinglayer_release"})
public final class InputTrackerImpl
implements InputTracker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InputObserver inputObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    private long focusStartTimestamp;
    @NotNull
    private String id;
    @Deprecated
    @NotNull
    public static final String name = "ComposeInputText";

    public InputTrackerImpl(@NotNull InputObserver inputObserver, @NotNull ScreenshotHandler screenshotHandler) {
        Intrinsics.checkNotNullParameter((Object)inputObserver, (String)"inputObserver");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        this.inputObserver = inputObserver;
        this.screenshotHandler = screenshotHandler;
        this.id = "";
    }

    @Override
    public void startInput(@NotNull String text, @Nullable LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (coordinates == null) {
            return;
        }
        this.focusStartTimestamp = System.currentTimeMillis();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.id = string;
        ViewMetadata viewMetadata = new UIComposeView(ViewMetadataKt.toViewMetadata(coordinates, this.id), null, null, null, 14, null).getMetadata();
        InputStartMetadata inputStartMetadata = new InputStartMetadata(viewMetadata.getViewId(), name, "", text);
        this.inputObserver.onInputStart(new Date(), viewMetadata, false, inputStartMetadata);
    }

    @Override
    public void addKeystroke(@NotNull String text, @NotNull LayoutCoordinates coordinates, @NotNull View view, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        UIComposeView uiComposeView = new UIComposeView(ViewMetadataKt.toViewMetadata(coordinates, this.id), view, window, null, 8, null);
        ViewMetadata viewMetadata = uiComposeView.getMetadata();
        KeystrokeMetadata keystrokeMetadata = new KeystrokeMetadata(this.id, text);
        this.screenshotHandler.takeScreenshot(uiComposeView, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, viewMetadata, keystrokeMetadata){
            final /* synthetic */ InputTrackerImpl this$0;
            final /* synthetic */ ViewMetadata $viewMetadata;
            final /* synthetic */ KeystrokeMetadata $keystrokeMetadata;
            {
                this.this$0 = $receiver;
                this.$viewMetadata = $viewMetadata;
                this.$keystrokeMetadata = $keystrokeMetadata;
                super(1);
            }

            public final void invoke(@Nullable Bitmap bitmap) {
                InputTrackerImpl.access$getInputObserver$p(this.this$0).onKeystroke(new Date(), this.$viewMetadata, false, this.$keystrokeMetadata, bitmap);
            }
        }));
    }

    @Override
    public void endInput(@NotNull String text, @Nullable LayoutCoordinates coordinates, @NotNull View view, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        InputEndMetadata inputEndMetadata = new InputEndMetadata(this.id, name, "", System.currentTimeMillis() - this.focusStartTimestamp, text);
        if (coordinates != null && coordinates.isAttached()) {
            UIComposeView uiComposeView = new UIComposeView(ViewMetadataKt.toViewMetadata(coordinates, this.id), view, window, null, 8, null);
            ViewMetadata viewMetadata = uiComposeView.getMetadata();
            this.screenshotHandler.takeScreenshot(uiComposeView, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, viewMetadata, inputEndMetadata){
                final /* synthetic */ InputTrackerImpl this$0;
                final /* synthetic */ ViewMetadata $viewMetadata;
                final /* synthetic */ InputEndMetadata $inputEndMetadata;
                {
                    this.this$0 = $receiver;
                    this.$viewMetadata = $viewMetadata;
                    this.$inputEndMetadata = $inputEndMetadata;
                    super(1);
                }

                public final void invoke(@Nullable Bitmap bitmap) {
                    InputTrackerImpl.access$getInputObserver$p(this.this$0).onInputEnd(new Date(), this.$viewMetadata, false, this.$inputEndMetadata, bitmap);
                }
            }));
        } else {
            this.inputObserver.onInputEnd(new Date(), new ViewMetadata(this.id, 0, 0, 0, 0), false, inputEndMetadata, null);
        }
    }

    public static final /* synthetic */ InputObserver access$getInputObserver$p(InputTrackerImpl $this) {
        return $this.inputObserver;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/InputTrackerImpl$Companion;", "", "()V", "name", "", "trackinglayer_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

