/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.utils;

import com.dynatrace.android.sessionreplay.tracking.helpers.EspressoTrackingIdlingResource;
import com.dynatrace.android.sessionreplay.tracking.utils.MainThreadExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fJ\u0016\u0010\u0010\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/utils/Debouncer;", "", "executor", "Ljava/util/concurrent/Executor;", "(Ljava/util/concurrent/Executor;)V", "pendingRunnable", "Ljava/util/concurrent/ScheduledFuture;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "cancel", "", "debounce", "delay", "", "block", "Lkotlin/Function0;", "execute", "trackinglayer_release"})
public final class Debouncer {
    @NotNull
    private final Executor executor;
    @NotNull
    private final ScheduledExecutorService scheduledExecutor;
    @Nullable
    private ScheduledFuture<?> pendingRunnable;

    public Debouncer(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        this.scheduledExecutor = scheduledExecutorService;
    }

    public /* synthetic */ Debouncer(Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            executor = new MainThreadExecutor();
        }
        this(executor);
    }

    public final synchronized void debounce(long delay, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.cancel();
        EspressoTrackingIdlingResource.INSTANCE.increment();
        this.pendingRunnable = this.scheduledExecutor.schedule(() -> Debouncer.debounce$lambda$0(this, block), delay, TimeUnit.MILLISECONDS);
    }

    private final void execute(Function0<Unit> block) {
        this.executor.execute(() -> Debouncer.execute$lambda$1(block));
        EspressoTrackingIdlingResource.INSTANCE.decrement();
    }

    private final void cancel() {
        ScheduledFuture<?> scheduledFuture = this.pendingRunnable;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.pendingRunnable = null;
        EspressoTrackingIdlingResource.INSTANCE.decrement();
    }

    private static final void debounce$lambda$0(Debouncer this$0, Function0 $block) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        this$0.execute((Function0<Unit>)$block);
    }

    private static final void execute$lambda$1(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public Debouncer() {
        this(null, 1, null);
    }
}

