/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking;

import android.animation.Animator;
import android.content.Context;
import android.view.View;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.CompoundButton;
import android.widget.RadioGroup;
import com.dynatrace.android.sessionreplay.tracking.InterceptionApi;
import com.dynatrace.android.sessionreplay.tracking.interceptors.InterceptorFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J2\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001c\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\t\u001a\u0004\u0018\u00010\u001eH\u0016J\u001c\u0010\u001f\u001a\u00020\u00062\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/InterceptionApiImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/InterceptionApi;", "interceptorFactory", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/InterceptorFactory;", "(Lcom/dynatrace/android/sessionreplay/tracking/interceptors/InterceptorFactory;)V", "instrumentCompoundButtonListener", "", "compoundButton", "Landroid/widget/CompoundButton;", "onCheckedChangeListener", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "instrumentFragmentAnimation", "Landroid/view/animation/Animation;", "fragment", "", "transit", "", "enter", "", "nextAnim", "context", "Landroid/content/Context;", "instrumentFragmentAnimator", "Landroid/animation/Animator;", "instrumentFragmentView", "view", "Landroid/view/View;", "instrumentRadioGroupListener", "radioGroup", "Landroid/widget/RadioGroup;", "Landroid/widget/RadioGroup$OnCheckedChangeListener;", "instrumentScrollListener", "listView", "Landroid/widget/AbsListView;", "listener", "Landroid/widget/AbsListView$OnScrollListener;", "instrumentTableReload", "adapter", "Landroid/widget/Adapter;", "instrumentWebView", "webView", "Landroid/webkit/WebView;", "client", "Landroid/webkit/WebViewClient;", "trackinglayer_release"})
public final class InterceptionApiImpl
implements InterceptionApi {
    @NotNull
    private final InterceptorFactory interceptorFactory;

    public InterceptionApiImpl(@NotNull InterceptorFactory interceptorFactory) {
        Intrinsics.checkNotNullParameter((Object)interceptorFactory, (String)"interceptorFactory");
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public void instrumentWebView(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.interceptorFactory.getWebLoadInterceptor().interceptWebView(webView);
    }

    @Override
    public void instrumentWebView(@NotNull WebView webView, @NotNull WebViewClient client) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.interceptorFactory.getWebLoadInterceptor().interceptWebView(webView, client);
    }

    @Override
    @Nullable
    public Animation instrumentFragmentAnimation(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.interceptorFactory.getFragmentInterceptor().interceptOnCreateFragmentAnimation(fragment, transit, enter, nextAnim, context);
    }

    @Override
    @Nullable
    public Animator instrumentFragmentAnimator(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.interceptorFactory.getFragmentInterceptor().interceptOnCreateFragmentAnimator(fragment, transit, enter, nextAnim, context);
    }

    @Override
    public void instrumentFragmentView(@NotNull Object fragment, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.interceptorFactory.getFragmentInterceptor().interceptFragmentView(fragment, view);
    }

    @Override
    public void instrumentTableReload(@NotNull View view, @NotNull Adapter adapter) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.interceptorFactory.getTableReloadInterceptor().interceptTableReload(adapter, view);
    }

    @Override
    public void instrumentScrollListener(@Nullable AbsListView listView, @Nullable AbsListView.OnScrollListener listener) {
        this.interceptorFactory.getListViewScrollInterceptor().interceptListView(listView, listener, true);
    }

    @Override
    public void instrumentRadioGroupListener(@Nullable RadioGroup radioGroup, @Nullable RadioGroup.OnCheckedChangeListener onCheckedChangeListener) {
        this.interceptorFactory.getRadioGroupInterceptor().interceptView(radioGroup, onCheckedChangeListener);
    }

    @Override
    public void instrumentCompoundButtonListener(@Nullable CompoundButton compoundButton, @Nullable CompoundButton.OnCheckedChangeListener onCheckedChangeListener) {
        this.interceptorFactory.getCompoundButtonInterceptor().interceptView(compoundButton, onCheckedChangeListener);
    }
}

