/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking;

import android.graphics.Rect;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import androidx.compose.ui.layout.LayoutCoordinates;
import com.dynatrace.android.sessionreplay.tracking.TrackingApi;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.UIContainer;
import com.dynatrace.android.sessionreplay.tracking.model.UIKeyEvent;
import com.dynatrace.android.sessionreplay.tracking.model.UIMotionEvent;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.trackers.CustomEventTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.DisplayViewTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.GenericEventTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.ScrollTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.TableReloadTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.TrackerFactory;
import com.dynatrace.android.sessionreplay.tracking.trackers.WindowActionTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.compose.ComposeTrackerFactory;
import com.dynatrace.android.sessionreplay.tracking.trackers.compose.CompoundButtonTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.compose.InputTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.compose.NavigationDrawerTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u000fH\u0016J2\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000fH\u0016J(\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0016J \u0010(\u001a\u00020\b2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020/H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/TrackingApiImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/TrackingApi;", "trackerFactory", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;", "composeTrackerFactory", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/ComposeTrackerFactory;", "(Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/ComposeTrackerFactory;)V", "trackComposeDisplay", "", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "trackCompoundChange", "value", "", "uiComposeView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIComposeView;", "trackCustomArea", "name", "", "rect", "Landroid/graphics/Rect;", "trackCustomFull", "trackCustomPartial", "trackGenericEvent", "withScreenshot", "trackInputFocus", "text", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "focused", "trackInputKeystroke", "trackKeyEvent", "keyEvent", "Landroid/view/KeyEvent;", "trackNavigationDrawerClosed", "uiContainer", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIContainer;", "trackNavigationDrawerOpened", "trackScroll", "deltaX", "", "deltaY", "trackTableReload", "trackWindowEvent", "motionEvent", "Landroid/view/MotionEvent;", "trackinglayer_release"})
public final class TrackingApiImpl
implements TrackingApi {
    @NotNull
    private final TrackerFactory trackerFactory;
    @NotNull
    private final ComposeTrackerFactory composeTrackerFactory;

    public TrackingApiImpl(@NotNull TrackerFactory trackerFactory, @NotNull ComposeTrackerFactory composeTrackerFactory) {
        Intrinsics.checkNotNullParameter((Object)trackerFactory, (String)"trackerFactory");
        Intrinsics.checkNotNullParameter((Object)composeTrackerFactory, (String)"composeTrackerFactory");
        this.trackerFactory = trackerFactory;
        this.composeTrackerFactory = composeTrackerFactory;
    }

    @Override
    public void trackScroll(@NotNull UIContainer uiContainer, int deltaX, int deltaY) {
        block2: {
            UIContainer uIContainer;
            block1: {
                Intrinsics.checkNotNullParameter((Object)uiContainer, (String)"uiContainer");
                uIContainer = uiContainer;
                if (!(uIContainer instanceof UIView)) break block1;
                ScrollTracker scrollTracker = this.trackerFactory.getScrollTracker();
                if (scrollTracker == null) break block2;
                scrollTracker.trackScroll((UIView)uiContainer, deltaX, deltaY);
                break block2;
            }
            if (!(uIContainer instanceof UIComposeView)) break block2;
            com.dynatrace.android.sessionreplay.tracking.trackers.compose.ScrollTracker scrollTracker = this.composeTrackerFactory.getScrollTracker();
            if (scrollTracker != null) {
                scrollTracker.trackScroll((UIComposeView)uiContainer);
            }
        }
    }

    @Override
    public void trackWindowEvent(@NotNull MotionEvent motionEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
            WindowActionTracker windowActionTracker = this.trackerFactory.getWindowActionTracker();
            if (windowActionTracker == null) break block0;
            windowActionTracker.trackTouch$trackinglayer_release(new UIMotionEvent(motionEvent));
        }
    }

    @Override
    public void trackKeyEvent(@NotNull KeyEvent keyEvent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
            WindowActionTracker windowActionTracker = this.trackerFactory.getWindowActionTracker();
            if (windowActionTracker == null) break block0;
            windowActionTracker.trackKey$trackinglayer_release(new UIKeyEvent(keyEvent));
        }
    }

    @Override
    public void trackNavigationDrawerOpened(@NotNull UIContainer uiContainer) {
        NavigationDrawerTracker navigationDrawerTracker;
        Intrinsics.checkNotNullParameter((Object)uiContainer, (String)"uiContainer");
        UIContainer uIContainer = uiContainer;
        if (uIContainer instanceof UIView) {
            com.dynatrace.android.sessionreplay.tracking.trackers.NavigationDrawerTracker navigationDrawerTracker2 = this.trackerFactory.getNavigationDrawerTracker();
            if (navigationDrawerTracker2 != null) {
                navigationDrawerTracker2.trackNavigationDrawerOpened((UIView)uiContainer);
            }
        } else if (uIContainer instanceof UIComposeView && (navigationDrawerTracker = this.composeTrackerFactory.getNavigationDrawerTracker()) != null) {
            navigationDrawerTracker.trackNavigationDrawerOpened((UIComposeView)uiContainer);
        }
    }

    @Override
    public void trackNavigationDrawerClosed(@NotNull UIContainer uiContainer) {
        NavigationDrawerTracker navigationDrawerTracker;
        Intrinsics.checkNotNullParameter((Object)uiContainer, (String)"uiContainer");
        UIContainer uIContainer = uiContainer;
        if (uIContainer instanceof UIView) {
            com.dynatrace.android.sessionreplay.tracking.trackers.NavigationDrawerTracker navigationDrawerTracker2 = this.trackerFactory.getNavigationDrawerTracker();
            if (navigationDrawerTracker2 != null) {
                navigationDrawerTracker2.trackNavigationDrawerClosed((UIView)uiContainer);
            }
        } else if (uIContainer instanceof UIComposeView && (navigationDrawerTracker = this.composeTrackerFactory.getNavigationDrawerTracker()) != null) {
            navigationDrawerTracker.trackNavigationDrawerClosed((UIComposeView)uiContainer);
        }
    }

    @Override
    public void trackCompoundChange(boolean value, @NotNull UIComposeView uiComposeView) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)uiComposeView, (String)"uiComposeView");
            CompoundButtonTracker compoundButtonTracker = this.composeTrackerFactory.getCompoundButtonTracker();
            if (compoundButtonTracker == null) break block0;
            compoundButtonTracker.trackCompoundButtonChange(value, uiComposeView);
        }
    }

    @Override
    public void trackInputKeystroke(@NotNull String text, @NotNull LayoutCoordinates coordinates, @NotNull View view, @NotNull Window window) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            InputTracker inputTracker = this.composeTrackerFactory.getInputTracker();
            if (inputTracker == null) break block0;
            inputTracker.addKeystroke(text, coordinates, view, window);
        }
    }

    @Override
    public void trackInputFocus(@NotNull String text, @Nullable LayoutCoordinates coordinates, @NotNull View view, @NotNull Window window, boolean focused) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)window, (String)"window");
                if (!focused) break block0;
                InputTracker inputTracker = this.composeTrackerFactory.getInputTracker();
                if (inputTracker == null) break block1;
                inputTracker.startInput(text, coordinates);
                break block1;
            }
            InputTracker inputTracker = this.composeTrackerFactory.getInputTracker();
            if (inputTracker == null) break block1;
            inputTracker.endInput(text, coordinates, view, window);
        }
    }

    @Override
    public void trackTableReload(@NotNull UIContainer uiContainer) {
        block2: {
            UIContainer uIContainer;
            block1: {
                Intrinsics.checkNotNullParameter((Object)uiContainer, (String)"uiContainer");
                uIContainer = uiContainer;
                if (!(uIContainer instanceof UIView)) break block1;
                TableReloadTracker tableReloadTracker = this.trackerFactory.getTableReloadTracker();
                if (tableReloadTracker == null) break block2;
                tableReloadTracker.trackTableReload((UIView)uiContainer);
                break block2;
            }
            if (!(uIContainer instanceof UIComposeView)) break block2;
            com.dynatrace.android.sessionreplay.tracking.trackers.compose.TableReloadTracker tableReloadTracker = this.composeTrackerFactory.getTableReloadTracker();
            if (tableReloadTracker != null) {
                tableReloadTracker.trackTableReload((UIComposeView)uiContainer);
            }
        }
    }

    @Override
    public void trackComposeDisplay(@NotNull View view, @NotNull Window window) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)window, (String)"window");
            UIComposeView viewHolder = new UIComposeView(ViewExtensionsKt.getMetadata(view), view, window, null, 8, null);
            DisplayViewTracker displayViewTracker = this.trackerFactory.getDisplayViewTracker();
            if (displayViewTracker == null) break block0;
            displayViewTracker.trackDisplayView(viewHolder);
        }
    }

    @Override
    public void trackCustomFull(@NotNull String name) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            CustomEventTracker customEventTracker = this.trackerFactory.getCustomTracker();
            if (customEventTracker == null) break block0;
            customEventTracker.trackCustomFull(name);
        }
    }

    @Override
    public void trackCustomPartial(@NotNull String name, @NotNull View view) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            CustomEventTracker customEventTracker = this.trackerFactory.getCustomTracker();
            if (customEventTracker == null) break block0;
            customEventTracker.trackCustomPartial(name, view);
        }
    }

    @Override
    public void trackCustomArea(@NotNull String name, @NotNull Rect rect) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
            CustomEventTracker customEventTracker = this.trackerFactory.getCustomTracker();
            if (customEventTracker == null) break block0;
            customEventTracker.trackCustomArea(name, rect);
        }
    }

    @Override
    public void trackGenericEvent(@NotNull String name, boolean withScreenshot) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            GenericEventTracker genericEventTracker = this.trackerFactory.getGenericTracker();
            if (genericEventTracker == null) break block0;
            genericEventTracker.trackGenericEvent(name, withScreenshot);
        }
    }
}

