/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.helpers;

import android.graphics.Rect;
import com.dynatrace.android.sessionreplay.tracking.extensions.RectExtensionsKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u0019\u0010\u000b\u001a\u00020\u00002\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0001J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u000fJ\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/helpers/DividedRectangles;", "", "rect", "Landroid/graphics/Rect;", "(Landroid/graphics/Rect;)V", "rectangles", "", "(Ljava/util/Set;)V", "getRectangles", "()Ljava/util/Set;", "component1", "copy", "difference", "with", "equals", "", "other", "hashCode", "", "intersection", "isEmpty", "toString", "", "trackinglayer_release"})
public final class DividedRectangles {
    @NotNull
    private final Set<Rect> rectangles;

    public DividedRectangles(@NotNull Set<Rect> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        this.rectangles = rectangles;
    }

    public /* synthetic */ DividedRectangles(Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            set = new LinkedHashSet();
        }
        this(set);
    }

    @NotNull
    public final Set<Rect> getRectangles() {
        return this.rectangles;
    }

    public DividedRectangles(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Object[] objectArray = new Rect[]{rect};
        this(SetsKt.mutableSetOf((Object[])objectArray));
    }

    public final boolean isEmpty() {
        for (Rect rect : this.rectangles) {
            boolean empty = rect.left >= rect.right || rect.top >= rect.bottom;
            if (empty) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final DividedRectangles intersection(@NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Set intersectionRectangles = new LinkedHashSet();
        for (Rect rectangle : this.rectangles) {
            Rect it;
            if (RectExtensionsKt.intersectWith(rectangle, rect) == null) continue;
            boolean bl = false;
            intersectionRectangles.add(it);
        }
        return new DividedRectangles(intersectionRectangles);
    }

    @NotNull
    public final DividedRectangles difference(@NotNull DividedRectangles with) {
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        Set differenceRectangles = new LinkedHashSet();
        for (Rect rect : this.rectangles) {
            Set<Rect> elements = RectExtensionsKt.difference(rect, with.rectangles);
            differenceRectangles.addAll((Collection)elements);
        }
        return new DividedRectangles(differenceRectangles);
    }

    @NotNull
    public final Set<Rect> component1() {
        return this.rectangles;
    }

    @NotNull
    public final DividedRectangles copy(@NotNull Set<Rect> rectangles) {
        Intrinsics.checkNotNullParameter(rectangles, (String)"rectangles");
        return new DividedRectangles(rectangles);
    }

    public static /* synthetic */ DividedRectangles copy$default(DividedRectangles dividedRectangles, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = dividedRectangles.rectangles;
        }
        return dividedRectangles.copy(set);
    }

    @NotNull
    public String toString() {
        return "DividedRectangles(rectangles=" + this.rectangles + ')';
    }

    public int hashCode() {
        return ((Object)this.rectangles).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DividedRectangles)) {
            return false;
        }
        DividedRectangles dividedRectangles = (DividedRectangles)other;
        return Intrinsics.areEqual(this.rectangles, dividedRectangles.rectangles);
    }

    public DividedRectangles() {
        this(null, 1, null);
    }
}

