/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.helpers;

import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.RectExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.helpers.DividedRectangles;
import com.dynatrace.android.sessionreplay.tracking.utils.ViewExtensionKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u00122\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\nJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\nJ\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "", "()V", "rectMaps", "Ljava/util/LinkedHashMap;", "", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/DividedRectangles;", "Lkotlin/collections/LinkedHashMap;", "cropRects", "viewOrParent", "Landroid/view/View;", "viewRect", "Landroid/graphics/Rect;", "getCroppedVisibleRect", "view", "getDrawableRect", "getMappedParent", "getViewFrames", "Lkotlin/Pair;", "getVisibleFrames", "updateViews", "", "needOcclusion", "", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nOcclusionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OcclusionHandler.kt\ncom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n215#2,2:201\n2624#3,3:203\n*S KotlinDebug\n*F\n+ 1 OcclusionHandler.kt\ncom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler\n*L\n145#1:201,2\n194#1:203,3\n*E\n"})
public final class OcclusionHandler {
    @NotNull
    private LinkedHashMap<Integer, DividedRectangles> rectMaps = new LinkedHashMap();

    public final void updateViews(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!this.needOcclusion(view)) {
            return;
        }
        this.rectMaps.clear();
        View contentView = view.findViewById(0x1020002);
        if (contentView == null || !(contentView instanceof ViewGroup) || ((ViewGroup)contentView).getChildCount() == 0) {
            return;
        }
        View topContent = ((ViewGroup)contentView).getChildAt(0);
        if (topContent instanceof ViewGroup) {
            for (int index = ((ViewGroup)topContent).getChildCount() - 1; -1 < index; --index) {
                View child = ((ViewGroup)topContent).getChildAt(index);
                Intrinsics.checkNotNull((Object)child);
                DividedRectangles dividedRectangles = this.getCroppedVisibleRect(child);
                ((Map)this.rectMaps).put(ViewExtensionKt.getIdentityHashCode(child), dividedRectangles);
            }
        }
        Log.d((String)"Occlusion", (String)"updateViews finished");
    }

    @NotNull
    public final DividedRectangles getVisibleFrames(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Rect viewRect = new Rect();
        boolean globallyVisible = view.getGlobalVisibleRect(viewRect);
        boolean isComposeView = ViewExtensionKt.isComposeView(view);
        if (!globallyVisible || isComposeView) {
            if (isComposeView) {
                DTLogger.INSTANCE.db("OcclusionHandler.getVisibleFrames: ComposeView detected area " + viewRect);
            }
        } else {
            View mappedParent = this.getMappedParent(view);
            return mappedParent != null ? this.cropRects(mappedParent, viewRect) : new DividedRectangles(viewRect);
        }
        Object[] objectArray = new Rect[]{viewRect};
        return new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray));
    }

    @NotNull
    public final Pair<DividedRectangles, Rect> getViewFrames(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Rect viewRect = new Rect();
        boolean globallyVisible = view.getGlobalVisibleRect(viewRect);
        if (globallyVisible && this.needOcclusion(view)) {
            Pair pair;
            View mappedParent = this.getMappedParent(view);
            if (mappedParent != null) {
                DividedRectangles dividedRectangles = this.rectMaps.get(ViewExtensionKt.getIdentityHashCode(mappedParent));
                if (dividedRectangles == null) {
                    dividedRectangles = new DividedRectangles(viewRect);
                }
                DividedRectangles dividedRectangles2 = dividedRectangles;
                pair = new Pair((Object)dividedRectangles2, (Object)viewRect);
            } else {
                pair = new Pair((Object)new DividedRectangles(viewRect), (Object)viewRect);
            }
            return pair;
        }
        Object[] objectArray = new Rect[]{viewRect};
        return new Pair((Object)new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray)), (Object)viewRect);
    }

    private final DividedRectangles cropRects(View viewOrParent, Rect viewRect) {
        DividedRectangles dividedRect;
        block0: {
            DividedRectangles rect;
            dividedRect = null;
            Object[] objectArray = new Rect[]{viewRect};
            dividedRect = new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray));
            DividedRectangles dividedRectangles = rect = viewOrParent != null ? this.rectMaps.get(ViewExtensionKt.getIdentityHashCode(viewOrParent)) : null;
            if (dividedRectangles == null) break block0;
            DividedRectangles it = dividedRectangles;
            boolean bl = false;
            dividedRect = it.intersection(viewRect);
        }
        return dividedRect;
    }

    private final DividedRectangles getCroppedVisibleRect(View view) {
        Rect visibleRect = this.getDrawableRect(view);
        DividedRectangles dividedRect = null;
        Object[] objectArray = new Rect[]{visibleRect};
        dividedRect = new DividedRectangles(SetsKt.mutableSetOf((Object[])objectArray));
        if (this.rectMaps.values().isEmpty()) {
            return dividedRect;
        }
        Map $this$forEach$iv = this.rectMaps;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            DividedRectangles rectangles = (DividedRectangles)entry.getValue();
            dividedRect = dividedRect.difference(rectangles);
        }
        return dividedRect;
    }

    private final Rect getDrawableRect(View view) {
        if (!ViewExtensionKt.isVisible(view)) {
            return new Rect();
        }
        Rect totalRect = new Rect();
        if (view.getBackground() == null && view instanceof ViewGroup) {
            for (int index = ((ViewGroup)view).getChildCount() - 1; -1 < index; --index) {
                View view2 = ((ViewGroup)view).getChildAt(index);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                Rect rect = this.getDrawableRect(view2);
                totalRect.union(rect);
            }
        } else {
            boolean globalVisibility = view.getGlobalVisibleRect(totalRect);
            if (!globalVisibility) {
                RectExtensionsKt.clear(totalRect);
            }
        }
        return totalRect;
    }

    private final View getMappedParent(View view) {
        View view2;
        if (this.rectMaps.containsKey(ViewExtensionKt.getIdentityHashCode(view))) {
            view2 = view;
        } else if (!(view.getParent() instanceof View)) {
            view2 = null;
        } else {
            ViewParent viewParent = view.getParent();
            Intrinsics.checkNotNull((Object)viewParent, (String)"null cannot be cast to non-null type android.view.View");
            view2 = this.getMappedParent((View)viewParent);
        }
        return view2;
    }

    private final boolean needOcclusion(View $this$needOcclusion) {
        return true;
    }
}

