/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound;

import android.graphics.drawable.AnimatedVectorDrawable;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ToggleButton;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.EspressoTrackingIdlingResource;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.AnimationEnd;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.CompoundButtonInterceptor;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.compound.CompoundUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.validator.CompoundValidation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u001e\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/CompoundButtonInterceptorImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/CompoundButtonInterceptor;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/CompoundValidation;", "Landroid/view/View;", "trackingHandler", "Lkotlin/Function3;", "", "", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/CompoundValidation;Lkotlin/jvm/functions/Function3;)V", "interceptView", "compoundButton", "Landroid/widget/CompoundButton;", "listener", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "Companion", "OnCheckedChangedListener", "trackinglayer_release"})
public final class CompoundButtonInterceptorImpl
implements CompoundButtonInterceptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompoundValidation<View> maskingValidator;
    @NotNull
    private final Function3<View, Boolean, Boolean, Unit> trackingHandler;
    private static final long DELAY_SWITCH = 250L;
    private static final long DELAY_BUTTONS = 150L;

    public CompoundButtonInterceptorImpl(@NotNull CompoundValidation<View> maskingValidator, @NotNull Function3<? super View, ? super Boolean, ? super Boolean, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(maskingValidator, (String)"maskingValidator");
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.maskingValidator = maskingValidator;
        this.trackingHandler = trackingHandler;
    }

    @Override
    public void interceptView(@Nullable CompoundButton compoundButton, @Nullable CompoundButton.OnCheckedChangeListener listener) {
        CompoundButton compoundButton2 = compoundButton;
        Integer id = compoundButton2 != null ? Integer.valueOf(compoundButton2.getId()) : null;
        DTLogger.INSTANCE.tracking("interceptView: CompoundButton " + id);
        CompoundButton compoundButton3 = compoundButton;
        Intrinsics.checkNotNull((Object)compoundButton3);
        compoundButton3.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)new OnCheckedChangedListener(listener));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/CompoundButtonInterceptorImpl$Companion;", "", "()V", "DELAY_BUTTONS", "", "DELAY_SWITCH", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/CompoundButtonInterceptorImpl$OnCheckedChangedListener;", "Landroid/widget/CompoundButton$OnCheckedChangeListener;", "listener", "(Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/compound/CompoundButtonInterceptorImpl;Landroid/widget/CompoundButton$OnCheckedChangeListener;)V", "getListener", "()Landroid/widget/CompoundButton$OnCheckedChangeListener;", "onCheckedChanged", "", "compoundButton", "Landroid/widget/CompoundButton;", "isChecked", "", "trackCheckedChanged", "trackCheckedChangedPostAnimation", "trackinglayer_release"})
    private final class OnCheckedChangedListener
    implements CompoundButton.OnCheckedChangeListener {
        @Nullable
        private final CompoundButton.OnCheckedChangeListener listener;

        public OnCheckedChangedListener(CompoundButton.OnCheckedChangeListener listener) {
            this.listener = listener;
        }

        @Nullable
        public final CompoundButton.OnCheckedChangeListener getListener() {
            return this.listener;
        }

        public void onCheckedChanged(@NotNull CompoundButton compoundButton, boolean isChecked) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)compoundButton, (String)"compoundButton");
                EspressoTrackingIdlingResource.INSTANCE.increment("CompoundButtonInterceptorImpl: onCheckedChanged");
                AnimatedVectorDrawable drawable = CompoundUtilsKt.getCustomButtonDrawable(compoundButton, compoundButton);
                if (drawable != null) {
                    CompoundUtilsKt.registerAnimatedDrawableListener(compoundButton, drawable, new AnimationEnd(this, compoundButton, isChecked){
                        final /* synthetic */ OnCheckedChangedListener this$0;
                        final /* synthetic */ CompoundButton $compoundButton;
                        final /* synthetic */ boolean $isChecked;
                        {
                            this.this$0 = $receiver;
                            this.$compoundButton = $compoundButton;
                            this.$isChecked = $isChecked;
                        }

                        public void onAnimationEnd() {
                            OnCheckedChangedListener.access$trackCheckedChangedPostAnimation(this.this$0, this.$compoundButton, this.$isChecked);
                        }
                    });
                } else {
                    this.trackCheckedChangedPostAnimation(compoundButton, isChecked);
                }
                CompoundButton.OnCheckedChangeListener onCheckedChangeListener = this.listener;
                if (onCheckedChangeListener == null) break block2;
                onCheckedChangeListener.onCheckedChanged(compoundButton, isChecked);
            }
        }

        private final void trackCheckedChangedPostAnimation(CompoundButton compoundButton, boolean isChecked) {
            CompoundButton compoundButton2 = compoundButton;
            if (compoundButton2 instanceof CheckBox) {
                compoundButton.postOnAnimationDelayed(() -> OnCheckedChangedListener.trackCheckedChangedPostAnimation$lambda$0(this, compoundButton, isChecked), 150L);
            } else if (compoundButton2 instanceof ToggleButton) {
                compoundButton.postOnAnimation(() -> OnCheckedChangedListener.trackCheckedChangedPostAnimation$lambda$1(this, compoundButton, isChecked));
            } else {
                compoundButton.postOnAnimationDelayed(() -> OnCheckedChangedListener.trackCheckedChangedPostAnimation$lambda$2(this, compoundButton, isChecked), 250L);
            }
        }

        private final void trackCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
            int id = compoundButton.getId();
            DTLogger.INSTANCE.tracking("CompoundButton " + id + ' ' + (isChecked ? "checked" : "unchecked"));
            boolean isMasked = CompoundButtonInterceptorImpl.this.maskingValidator.validate(compoundButton);
            CompoundButtonInterceptorImpl.this.trackingHandler.invoke((Object)compoundButton, (Object)isChecked, (Object)isMasked);
        }

        private static final void trackCheckedChangedPostAnimation$lambda$0(OnCheckedChangedListener this$0, CompoundButton $compoundButton, boolean $isChecked) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$compoundButton, (String)"$compoundButton");
            this$0.trackCheckedChanged($compoundButton, $isChecked);
            EspressoTrackingIdlingResource.INSTANCE.decrement("CompoundButtonInterceptorImpl: checkBox");
        }

        private static final void trackCheckedChangedPostAnimation$lambda$1(OnCheckedChangedListener this$0, CompoundButton $compoundButton, boolean $isChecked) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$compoundButton, (String)"$compoundButton");
            this$0.trackCheckedChanged($compoundButton, $isChecked);
            EspressoTrackingIdlingResource.INSTANCE.decrement("CompoundButtonInterceptorImpl: ToggleButton");
        }

        private static final void trackCheckedChangedPostAnimation$lambda$2(OnCheckedChangedListener this$0, CompoundButton $compoundButton, boolean $isChecked) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$compoundButton, (String)"$compoundButton");
            this$0.trackCheckedChanged($compoundButton, $isChecked);
            EspressoTrackingIdlingResource.INSTANCE.decrement("CompoundButtonInterceptorImpl: else");
        }

        public static final /* synthetic */ void access$trackCheckedChangedPostAnimation(OnCheckedChangedListener $this, CompoundButton compoundButton, boolean isChecked) {
            $this.trackCheckedChangedPostAnimation(compoundButton, isChecked);
        }
    }
}

