/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl.fragments;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.dynatrace.android.sessionreplay.tracking.interceptors.FragmentInterceptor;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.fragments.OnFragmentAnimationEndListener;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.fragments.OnFragmentAnimatorEndListener;
import com.dynatrace.android.sessionreplay.tracking.utils.InterceptionCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J2\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J2\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\b\b\u0002\u0010\u001e\u001a\u00020\u0018H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/fragments/FragmentInterceptorImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/FragmentInterceptor;", "Landroid/view/View;", "trackingHandler", "Lkotlin/Function2;", "", "", "(Lkotlin/jvm/functions/Function2;)V", "interceptedFragmentViews", "Lcom/dynatrace/android/sessionreplay/tracking/utils/InterceptionCache;", "", "addAnimationListener", "animation", "Landroid/view/animation/Animation;", "fragment", "addAnimatorListener", "animator", "Landroid/animation/Animator;", "interceptFragmentView", "view", "interceptOnCreateFragmentAnimation", "transit", "", "enter", "", "nextAnim", "context", "Landroid/content/Context;", "interceptOnCreateFragmentAnimator", "trackFragment", "withAfterMeasure", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nFragmentInterceptorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentInterceptorImpl.kt\ncom/dynatrace/android/sessionreplay/tracking/interceptors/impl/fragments/FragmentInterceptorImpl\n+ 2 ViewExtensions.kt\ncom/dynatrace/android/sessionreplay/tracking/extensions/ViewExtensionsKt\n*L\n1#1,114:1\n29#2,9:115\n*S KotlinDebug\n*F\n+ 1 FragmentInterceptorImpl.kt\ncom/dynatrace/android/sessionreplay/tracking/interceptors/impl/fragments/FragmentInterceptorImpl\n*L\n107#1:115,9\n*E\n"})
public final class FragmentInterceptorImpl
implements FragmentInterceptor<View> {
    @NotNull
    private final Function2<View, String, Unit> trackingHandler;
    @NotNull
    private final InterceptionCache<Object, View> interceptedFragmentViews;

    public FragmentInterceptorImpl(@NotNull Function2<? super View, ? super String, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.trackingHandler = trackingHandler;
        this.interceptedFragmentViews = new InterceptionCache();
    }

    @Override
    public void interceptFragmentView(@NotNull Object fragment, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.interceptedFragmentViews.set(fragment, view);
    }

    @Override
    @Nullable
    public Animation interceptOnCreateFragmentAnimation(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (nextAnim == 0 || !enter) {
            return null;
        }
        String dir = context.getResources().getResourceTypeName(nextAnim);
        boolean isAnim = Intrinsics.areEqual((Object)"anim", (Object)dir);
        if (isAnim) {
            try {
                Animation animation = AnimationUtils.loadAnimation((Context)context, (int)nextAnim);
                if (animation != null) {
                    this.addAnimationListener(animation, fragment);
                    return animation;
                }
            }
            catch (Resources.NotFoundException notFoundException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Animator interceptOnCreateFragmentAnimator(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (nextAnim == 0 || !enter) {
            if (enter) {
                FragmentInterceptorImpl.trackFragment$default(this, fragment, false, 2, null);
            }
            return null;
        }
        try {
            Animator animator = AnimatorInflater.loadAnimator((Context)context, (int)nextAnim);
            if (animator != null) {
                this.addAnimatorListener(animator, fragment);
                return animator;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        FragmentInterceptorImpl.trackFragment$default(this, fragment, false, 2, null);
        return null;
    }

    private final void addAnimationListener(Animation animation, Object fragment) {
        animation.setAnimationListener((Animation.AnimationListener)new OnFragmentAnimationEndListener(fragment, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){
            final /* synthetic */ FragmentInterceptorImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FragmentInterceptorImpl.trackFragment$default(this.this$0, it, false, 2, null);
            }
        })));
    }

    private final void addAnimatorListener(Animator animator, Object fragment) {
        animator.addListener((Animator.AnimatorListener)new OnFragmentAnimatorEndListener(fragment, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(this){
            final /* synthetic */ FragmentInterceptorImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Object it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                FragmentInterceptorImpl.trackFragment$default(this.this$0, it, false, 2, null);
            }
        })));
    }

    private final void trackFragment(Object fragment, boolean withAfterMeasure) {
        block0: {
            View view;
            block1: {
                View view2 = this.interceptedFragmentViews.get(fragment);
                if (view2 == null) break block0;
                view = view2;
                boolean bl = false;
                if (view.getWidth() <= 0 || view.getHeight() <= 0) break block1;
                String string = fragment.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                this.trackingHandler.invoke((Object)view, (Object)string);
                break block0;
            }
            if (!withAfterMeasure) break block0;
            View $this$afterMeasured$iv = view;
            boolean $i$f$afterMeasured = false;
            $this$afterMeasured$iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($this$afterMeasured$iv, this, fragment){
                final /* synthetic */ View $this_afterMeasured;
                final /* synthetic */ FragmentInterceptorImpl this$0;
                final /* synthetic */ Object $fragment$inlined;
                {
                    this.$this_afterMeasured = $receiver;
                    this.this$0 = fragmentInterceptorImpl;
                    this.$fragment$inlined = object;
                }

                public void onGlobalLayout() {
                    if (this.$this_afterMeasured.getMeasuredWidth() > 0 && this.$this_afterMeasured.getMeasuredHeight() > 0) {
                        this.$this_afterMeasured.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        View $this$trackFragment_u24lambda_u241_u24lambda_u240 = this.$this_afterMeasured;
                        boolean bl = false;
                        FragmentInterceptorImpl.access$trackFragment(this.this$0, this.$fragment$inlined, false);
                    }
                }
            });
        }
    }

    static /* synthetic */ void trackFragment$default(FragmentInterceptorImpl fragmentInterceptorImpl, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        fragmentInterceptorImpl.trackFragment(object, bl);
    }

    public static final /* synthetic */ void access$trackFragment(FragmentInterceptorImpl $this, Object fragment, boolean withAfterMeasure) {
        $this.trackFragment(fragment, withAfterMeasure);
    }
}

