/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.listeners;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.interceptors.InterceptorFactory;
import com.dynatrace.android.sessionreplay.tracking.interceptors.KeyboardInterceptor;
import com.dynatrace.android.sessionreplay.tracking.listeners.UIState;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.trackers.DisplayViewTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.LifecycleTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.ResolutionTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.TrackerFactory;
import com.dynatrace.android.sessionreplay.tracking.utils.ActivityUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/listeners/ApplicationCallback;", "Landroid/app/Application$ActivityLifecycleCallbacks;", "trackerFactory", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;", "uiState", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;", "interceptorFactory", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/InterceptorFactory;", "(Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;Lcom/dynatrace/android/sessionreplay/tracking/interceptors/InterceptorFactory;)V", "activityRecreating", "", "keyboardInterceptor", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/KeyboardInterceptor;", "onActivityCreated", "", "activity", "Landroid/app/Activity;", "savedInstanceState", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "outState", "onActivityStarted", "onActivityStopped", "trackActivity", "translateOrientation", "", "configOrientation", "Companion", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nApplicationCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationCallback.kt\ncom/dynatrace/android/sessionreplay/tracking/listeners/ApplicationCallback\n+ 2 ViewExtensions.kt\ncom/dynatrace/android/sessionreplay/tracking/extensions/ViewExtensionsKt\n*L\n1#1,117:1\n29#2,9:118\n*S KotlinDebug\n*F\n+ 1 ApplicationCallback.kt\ncom/dynatrace/android/sessionreplay/tracking/listeners/ApplicationCallback\n*L\n52#1:118,9\n*E\n"})
public final class ApplicationCallback
implements Application.ActivityLifecycleCallbacks {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrackerFactory trackerFactory;
    @NotNull
    private final UIState uiState;
    @NotNull
    private final InterceptorFactory interceptorFactory;
    private boolean activityRecreating;
    @NotNull
    private final KeyboardInterceptor keyboardInterceptor;
    private static final int ORIENTATION_PORTRAIT = 0;
    private static final int ORIENTATION_REVERSE_PORTRAIT = 180;
    private static final int ORIENTATION_LANDSCAPE = 270;
    private static final int ORIENTATION_REVERSE_LANDSCAPE = 90;

    public ApplicationCallback(@NotNull TrackerFactory trackerFactory, @NotNull UIState uiState, @NotNull InterceptorFactory interceptorFactory) {
        Intrinsics.checkNotNullParameter((Object)trackerFactory, (String)"trackerFactory");
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)interceptorFactory, (String)"interceptorFactory");
        this.trackerFactory = trackerFactory;
        this.uiState = uiState;
        this.interceptorFactory = interceptorFactory;
        this.keyboardInterceptor = this.interceptorFactory.getKeyboardInterceptor();
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.activityRecreating = savedInstanceState != null;
    }

    public void onActivityStarted(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            DTLogger.INSTANCE.info("Activity " + activity + " Started");
            LifecycleTracker lifecycleTracker = this.trackerFactory.getLifecycleTracker();
            if (lifecycleTracker == null) break block0;
            lifecycleTracker.onActivityStarted(activity);
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        UIState uIState;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        DTLogger.INSTANCE.info("Activity " + activity + " Resumed");
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
        View decorView = view;
        String activityName = activity.getClass().getSimpleName();
        UIState $this$onActivityResumed_u24lambda_u240 = uIState = this.uiState;
        boolean bl = false;
        $this$onActivityResumed_u24lambda_u240.setCurrentView(new UIView(decorView, activity.getWindow(), null, 4, null));
        $this$onActivityResumed_u24lambda_u240.setCurrentActivityName(activityName);
        int viewWidth = decorView.getWidth();
        int viewHeight = decorView.getHeight();
        if (viewHeight == 0 && viewWidth == 0) {
            View $this$afterMeasured$iv = decorView;
            boolean $i$f$afterMeasured = false;
            $this$afterMeasured$iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($this$afterMeasured$iv, this, activity){
                final /* synthetic */ View $this_afterMeasured;
                final /* synthetic */ ApplicationCallback this$0;
                final /* synthetic */ Activity $activity$inlined;
                {
                    this.$this_afterMeasured = $receiver;
                    this.this$0 = applicationCallback;
                    this.$activity$inlined = activity;
                }

                public void onGlobalLayout() {
                    if (this.$this_afterMeasured.getMeasuredWidth() > 0 && this.$this_afterMeasured.getMeasuredHeight() > 0) {
                        this.$this_afterMeasured.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        View $this$onActivityResumed_u24lambda_u241 = this.$this_afterMeasured;
                        boolean bl = false;
                        ApplicationCallback.access$trackActivity(this.this$0, this.$activity$inlined);
                    }
                }
            });
        } else {
            this.trackActivity(activity);
        }
        ViewGroup rootView = ActivityUtilsKt.getRootView(activity);
        this.interceptorFactory.getViewInterceptor().interceptView((ViewGroup)((View)rootView));
        View view2 = (View)rootView;
        Window window = activity.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        this.keyboardInterceptor.intercept(view2, decorView, window);
    }

    public void onActivityPaused(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            DTLogger.INSTANCE.info("Activity " + activity + " Paused");
            LifecycleTracker lifecycleTracker = this.trackerFactory.getLifecycleTracker();
            if (lifecycleTracker == null) break block0;
            lifecycleTracker.onActivityPaused(activity);
        }
    }

    public void onActivityStopped(@NotNull Activity activity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            DTLogger.INSTANCE.info("Activity " + activity + " Stopped");
            LifecycleTracker lifecycleTracker = this.trackerFactory.getLifecycleTracker();
            if (lifecycleTracker == null) break block0;
            lifecycleTracker.onActivityStopped(activity);
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        DTLogger.INSTANCE.info("Activity " + activity + " SaveInstanceState");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        DTLogger.INSTANCE.info("Activity " + activity + " Destroyed");
        String activityName = activity.getClass().getSimpleName();
        if (Intrinsics.areEqual((Object)this.uiState.getCurrentActivityName(), (Object)activityName)) {
            this.uiState.setCurrentView(null);
            this.uiState.setCurrentActivityName(null);
        }
    }

    private final void trackActivity(Activity activity) {
        UIView view = new UIView(activity.getWindow().getDecorView(), activity.getWindow(), null, 4, null);
        if (this.activityRecreating) {
            ResolutionTracker resolutionTracker = this.trackerFactory.getResolutionTracker();
            if (resolutionTracker != null) {
                resolutionTracker.trackResolutionChange(view, this.translateOrientation(ActivityUtilsKt.getScreenRotation(activity)));
            }
        } else {
            DisplayViewTracker displayViewTracker = this.trackerFactory.getDisplayViewTracker();
            if (displayViewTracker != null) {
                displayViewTracker.trackDisplayView(view);
            }
        }
        this.activityRecreating = false;
    }

    private final int translateOrientation(int configOrientation) {
        int n;
        switch (configOrientation) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 270;
                break;
            }
            case 2: {
                n = 180;
                break;
            }
            case 3: {
                n = 90;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }

    public static final /* synthetic */ void access$trackActivity(ApplicationCallback $this, Activity activity) {
        $this.trackActivity(activity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/listeners/ApplicationCallback$Companion;", "", "()V", "ORIENTATION_LANDSCAPE", "", "ORIENTATION_PORTRAIT", "ORIENTATION_REVERSE_LANDSCAPE", "ORIENTATION_REVERSE_PORTRAIT", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

