/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.listeners;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.dynatrace.android.sessionreplay.tracking.trackers.NavigationTracker;
import com.dynatrace.android.sessionreplay.tracking.trackers.TrackerFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/listeners/NavigationWatcher;", "", "trackerFactory", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;", "(Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;)V", "filter", "Landroid/content/IntentFilter;", "receiver", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/NavigationWatcher$NavigationReceiver;", "startWatch", "", "context", "Landroid/content/Context;", "stopWatchForTesting", "NavigationReceiver", "trackinglayer_release"})
public final class NavigationWatcher {
    @NotNull
    private final TrackerFactory trackerFactory;
    @NotNull
    private final IntentFilter filter;
    @Nullable
    private NavigationReceiver receiver;

    public NavigationWatcher(@NotNull TrackerFactory trackerFactory) {
        Intrinsics.checkNotNullParameter((Object)trackerFactory, (String)"trackerFactory");
        this.trackerFactory = trackerFactory;
        this.filter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
    }

    public final void startWatch(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.receiver == null) {
            this.receiver = new NavigationReceiver(this.trackerFactory);
            if (Build.VERSION.SDK_INT >= 33) {
                context.registerReceiver((BroadcastReceiver)this.receiver, this.filter, 4);
            } else {
                context.registerReceiver((BroadcastReceiver)this.receiver, this.filter);
            }
        }
    }

    public final void stopWatchForTesting(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/listeners/NavigationWatcher$NavigationReceiver;", "Landroid/content/BroadcastReceiver;", "trackerFactory", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;", "(Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;)V", "getTrackerFactory", "()Lcom/dynatrace/android/sessionreplay/tracking/trackers/TrackerFactory;", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "Companion", "trackinglayer_release"})
    private static final class NavigationReceiver
    extends BroadcastReceiver {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private final TrackerFactory trackerFactory;
        @NotNull
        private static final String SYSTEM_DIALOG_REASON_KEY = "reason";
        @NotNull
        private static final String SYSTEM_DIALOG_REASON_RECENT_APPS = "recentapps";
        @NotNull
        private static final String SYSTEM_DIALOG_REASON_HOME_KEY = "homekey";

        public NavigationReceiver(@NotNull TrackerFactory trackerFactory) {
            Intrinsics.checkNotNullParameter((Object)trackerFactory, (String)"trackerFactory");
            this.trackerFactory = trackerFactory;
        }

        @NotNull
        public final TrackerFactory getTrackerFactory() {
            return this.trackerFactory;
        }

        public void onReceive(@Nullable Context context, @NotNull Intent intent) {
            block1: {
                String reason;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    String action = intent.getAction();
                    if (!Intrinsics.areEqual((Object)action, (Object)"android.intent.action.CLOSE_SYSTEM_DIALOGS") || (reason = intent.getStringExtra(SYSTEM_DIALOG_REASON_KEY)) == null) break block1;
                    if (!Intrinsics.areEqual((Object)reason, (Object)SYSTEM_DIALOG_REASON_HOME_KEY)) break block2;
                    NavigationTracker navigationTracker = this.trackerFactory.getNavigationTracker();
                    if (navigationTracker == null) break block1;
                    navigationTracker.trackNavigationEvent(NavigationTracker.NavigationType.HOME);
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)reason, (Object)SYSTEM_DIALOG_REASON_RECENT_APPS)) break block1;
                NavigationTracker navigationTracker = this.trackerFactory.getNavigationTracker();
                if (navigationTracker != null) {
                    navigationTracker.trackNavigationEvent(NavigationTracker.NavigationType.RECENTS);
                }
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/listeners/NavigationWatcher$NavigationReceiver$Companion;", "", "()V", "SYSTEM_DIALOG_REASON_HOME_KEY", "", "SYSTEM_DIALOG_REASON_KEY", "SYSTEM_DIALOG_REASON_RECENT_APPS", "trackinglayer_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

