/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import androidx.annotation.RequiresApi;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.BitmapSize;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugBitmapHelper;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugOverlay;
import com.dynatrace.android.sessionreplay.tracking.helpers.DividedRectangles;
import com.dynatrace.android.sessionreplay.tracking.helpers.OcclusionHandler;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandlerUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskedArea;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskingHandler;
import com.dynatrace.android.sessionreplay.tracking.utils.ViewExtensionKt;
import com.dynatrace.android.sessionreplay.tracking.validator.screenshot.ScreenshotValidator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J5\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2#\u0010\u001b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00180\u001cH\u0002J\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J3\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2#\u0010\u001b\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0010\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00180\u001cR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/PixelCopyNativeScreenshotHandler;", "", "screenshotValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/screenshot/ScreenshotValidator;", "occlusionHandler", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "maskingHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;", "Landroid/view/View;", "composeMaskingHandler", "", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedArea;", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedAreas;", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/screenshot/ScreenshotValidator;Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;)V", "composeMaskedRects", "drawPartialBitmapUnCropped", "Landroid/graphics/Bitmap;", "rootBitmap", "viewRect", "Landroid/graphics/Rect;", "getPartialBitmap", "view", "getPartialBitmapUnCropped", "getRootBitmap", "", "uiView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "function", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "bitmap", "mask", "takeFullScreenshot", "takePartialScreenshot", "takeScreenshot", "trackinglayer_release"})
@RequiresApi(value=26)
public final class PixelCopyNativeScreenshotHandler {
    @NotNull
    private final ScreenshotValidator screenshotValidator;
    @NotNull
    private final OcclusionHandler occlusionHandler;
    @NotNull
    private final MaskingHandler<View> maskingHandler;
    @NotNull
    private final MaskingHandler<List<MaskedArea>> composeMaskingHandler;
    @NotNull
    private List<MaskedArea> composeMaskedRects;

    public PixelCopyNativeScreenshotHandler(@NotNull ScreenshotValidator screenshotValidator, @NotNull OcclusionHandler occlusionHandler, @NotNull MaskingHandler<View> maskingHandler, @NotNull MaskingHandler<List<MaskedArea>> composeMaskingHandler) {
        Intrinsics.checkNotNullParameter((Object)screenshotValidator, (String)"screenshotValidator");
        Intrinsics.checkNotNullParameter((Object)occlusionHandler, (String)"occlusionHandler");
        Intrinsics.checkNotNullParameter(maskingHandler, (String)"maskingHandler");
        Intrinsics.checkNotNullParameter(composeMaskingHandler, (String)"composeMaskingHandler");
        this.screenshotValidator = screenshotValidator;
        this.occlusionHandler = occlusionHandler;
        this.maskingHandler = maskingHandler;
        this.composeMaskingHandler = composeMaskingHandler;
        this.composeMaskedRects = CollectionsKt.emptyList();
    }

    public final void takeScreenshot(@NotNull UIView uiView, @NotNull Function1<? super Bitmap, Unit> function) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)uiView, (String)"uiView");
            Intrinsics.checkNotNullParameter(function, (String)"function");
            this.composeMaskedRects = CollectionsKt.toList((Iterable)uiView.getMaskedAreas());
            View view = uiView.getContainerView();
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            if (view2.getWidth() <= 0 || view2.getHeight() <= 0) {
                DTLogger.INSTANCE.tracking("Record: no view or no size with view=" + view2 + " and " + view2.getWidth() + 'x' + view2.getHeight());
                return;
            }
            this.getRootBitmap(uiView, function);
        }
    }

    private final void getRootBitmap(UIView uiView, Function1<? super Bitmap, Unit> function) {
        block0: {
            View view;
            View view2 = view = uiView.getContainerView();
            if (view2 == null) break block0;
            view2.post(() -> PixelCopyNativeScreenshotHandler.getRootBitmap$lambda$2(view, uiView, this, function));
        }
    }

    private final Bitmap takeFullScreenshot(View view, Bitmap rootBitmap) {
        View view2 = view.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        this.occlusionHandler.updateViews(view2);
        return this.mask(view, rootBitmap);
    }

    private final Bitmap takePartialScreenshot(View view, Bitmap rootBitmap) {
        if (!this.screenshotValidator.validate(view)) {
            DTLogger.INSTANCE.info("Track: partial screenshot will be null");
            return null;
        }
        return this.getPartialBitmap(view, rootBitmap);
    }

    private final Bitmap mask(View view, Bitmap bitmap) {
        Canvas rootCanvas = new Canvas(bitmap);
        this.maskingHandler.mask(view, rootCanvas, bitmap);
        if (!((Collection)ViewExtensionKt.findComposeViews(view)).isEmpty()) {
            this.composeMaskingHandler.mask(this.composeMaskedRects, rootCanvas, bitmap);
        }
        return bitmap;
    }

    private final Bitmap getPartialBitmap(View view, Bitmap rootBitmap) {
        Pair<DividedRectangles, Rect> viewFrames = this.occlusionHandler.getViewFrames(view);
        Set<Rect> viewVisibleRects = ((DividedRectangles)viewFrames.getFirst()).getRectangles();
        Rect viewRect = (Rect)viewFrames.getSecond();
        Bitmap bitmap = this.getPartialBitmapUnCropped(view, viewRect, rootBitmap);
        if (bitmap == null) {
            return null;
        }
        Bitmap viewBitmap = bitmap;
        Bitmap bitmap2 = Bitmap.createBitmap((int)viewRect.width(), (int)viewRect.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        Bitmap finalPartialBitmap = bitmap2;
        Canvas canvas = new Canvas(finalPartialBitmap);
        for (Rect visibleRect : viewVisibleRects) {
            BitmapSize bitmapSize = BitmapSize.Companion.from(visibleRect, viewRect, finalPartialBitmap, viewBitmap);
            if (bitmapSize.getWidth() <= 0 || bitmapSize.getHeight() <= 0) {
                DTLogger.INSTANCE.tracking("Record: invalid size " + bitmapSize.getWidth() + 'x' + bitmapSize.getHeight());
                continue;
            }
            try {
                Bitmap createBitmap;
                Intrinsics.checkNotNullExpressionValue((Object)Bitmap.createBitmap((Bitmap)viewBitmap, (int)bitmapSize.getX(), (int)bitmapSize.getY(), (int)bitmapSize.getWidth(), (int)bitmapSize.getHeight()), (String)"createBitmap(...)");
                canvas.drawBitmap(createBitmap, (float)bitmapSize.getX(), (float)bitmapSize.getY(), null);
            }
            catch (Exception e) {
                DTLogger.INSTANCE.error(ExceptionsKt.stackTraceToString((Throwable)e));
            }
        }
        return finalPartialBitmap;
    }

    private final Bitmap getPartialBitmapUnCropped(View view, Rect viewRect, Bitmap rootBitmap) {
        View view2 = view.getRootView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        Bitmap maskedBitmap = this.mask(view2, rootBitmap);
        return this.drawPartialBitmapUnCropped(maskedBitmap, viewRect);
    }

    private final Bitmap drawPartialBitmapUnCropped(Bitmap rootBitmap, Rect viewRect) {
        Pair<Integer, Integer> pair = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewRect.left, viewRect.right - viewRect.left, rootBitmap.getWidth());
        int x = ((Number)pair.component1()).intValue();
        int width = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewRect.top, viewRect.bottom - viewRect.top, rootBitmap.getHeight());
        int y = ((Number)pair2.component1()).intValue();
        int height = ((Number)pair2.component2()).intValue();
        if (width <= 0 || height <= 0) {
            DTLogger.INSTANCE.tracking("Record: invalid size " + width + 'x' + height);
            return null;
        }
        return Bitmap.createBitmap((Bitmap)rootBitmap, (int)x, (int)y, (int)width, (int)height);
    }

    private static final void getRootBitmap$lambda$2$lambda$1(View $view, PixelCopyNativeScreenshotHandler this$0, Bitmap $rootBitmap, UIView $uiView, Function1 $function, int it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rootBitmap, (String)"$rootBitmap");
        Intrinsics.checkNotNullParameter((Object)$uiView, (String)"$uiView");
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        DTLogger.INSTANCE.info("PixelCopy Screenshot finished");
        Bitmap bitmap = Intrinsics.areEqual((Object)$view, (Object)$view.getRootView()) ? this$0.takeFullScreenshot($view, $rootBitmap) : this$0.takePartialScreenshot($view, $rootBitmap);
        DebugBitmapHelper.INSTANCE.saveBitmap$trackinglayer_release($view, bitmap);
        DebugOverlay.INSTANCE.showDebugOverlay($uiView, bitmap);
        $function.invoke((Object)bitmap);
    }

    private static final void getRootBitmap$lambda$2(View $view, UIView $uiView, PixelCopyNativeScreenshotHandler this$0, Function1 $function) {
        Intrinsics.checkNotNullParameter((Object)$uiView, (String)"$uiView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$function, (String)"$function");
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)$view.getRootView().getWidth(), (int)$view.getRootView().getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
            Bitmap rootBitmap = bitmap;
            Window window = $uiView.getContainerWindow();
            if (window == null) {
                window = ScreenshotHandlerUtilsKt.getWindow($view);
            }
            Window window2 = window;
            PixelCopy.request((Window)window2, null, (Bitmap)rootBitmap, arg_0 -> PixelCopyNativeScreenshotHandler.getRootBitmap$lambda$2$lambda$1($view, this$0, rootBitmap, $uiView, $function, arg_0), (Handler)new Handler(Looper.getMainLooper()));
        }
        catch (Exception ex) {
            DTLogger.INSTANCE.error("Error trying to get root bitmap: " + ex);
        }
    }
}

