/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot.masking;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.VectorDrawable;
import android.widget.Button;
import androidx.palette.graphics.Palette;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J%\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0010J*\u0010\u0011\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0016\u001a\u00020\b*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0014\u0010\u0017\u001a\u00020\u0018*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0011\u0010\u0019\u001a\u00020\u0004*\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingColorHelper;", "", "()V", "getBitmapDominantColor", "", "bitmap", "Landroid/graphics/Bitmap;", "rect", "Landroid/graphics/Rect;", "getBitmapDominantColor$trackinglayer_release", "getBitmapDrawableColor", "drawable", "Landroid/graphics/drawable/BitmapDrawable;", "getButtonColor", "button", "Landroid/widget/Button;", "getButtonColor$trackinglayer_release", "getButtonDrawableColor", "Landroid/graphics/drawable/Drawable;", "getLayerDrawableColor", "Landroid/graphics/drawable/LayerDrawable;", "crop", "getSafeRect", "isSameSize", "", "removeAlpha", "removeAlpha$trackinglayer_release", "trackinglayer_release"})
public final class MaskingColorHelper {
    @NotNull
    public static final MaskingColorHelper INSTANCE = new MaskingColorHelper();

    private MaskingColorHelper() {
    }

    public final int getButtonColor$trackinglayer_release(@NotNull Button button, @NotNull Bitmap bitmap, @NotNull Rect rect) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return this.getButtonDrawableColor(button.getBackground(), button, bitmap, rect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBitmapDominantColor$trackinglayer_release(@NotNull Bitmap bitmap, @NotNull Rect rect) {
        int n;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Bitmap bitmap2 = this.crop(bitmap, rect);
        if (bitmap2 != null) {
            int n2;
            Bitmap croppedBitmap = bitmap2;
            boolean bl = false;
            try {
                Palette palette = Palette.from((Bitmap)croppedBitmap).generate();
                Intrinsics.checkNotNullExpressionValue((Object)palette, (String)"generate(...)");
                Palette palette2 = palette;
                n2 = palette2.getMutedColor(-16777216);
            }
            finally {
                if (!Intrinsics.areEqual((Object)croppedBitmap, (Object)bitmap)) {
                    croppedBitmap.recycle();
                }
            }
            n = n2;
        } else {
            n = -16777216;
        }
        return n;
    }

    public final int removeAlpha$trackinglayer_release(int $this$removeAlpha) {
        return Color.rgb((int)Color.red((int)$this$removeAlpha), (int)Color.green((int)$this$removeAlpha), (int)Color.blue((int)$this$removeAlpha));
    }

    private final int getButtonDrawableColor(Drawable drawable, Button button, Bitmap bitmap, Rect rect) {
        Drawable drawable2 = drawable;
        return (drawable2 instanceof GradientDrawable ? true : drawable2 instanceof VectorDrawable) ? this.getBitmapDominantColor$trackinglayer_release(bitmap, rect) : (drawable2 instanceof ColorDrawable ? ((ColorDrawable)drawable).getColor() : (drawable2 instanceof BitmapDrawable ? this.getBitmapDrawableColor((BitmapDrawable)drawable) : (drawable2 instanceof StateListDrawable ? this.getButtonDrawableColor(((StateListDrawable)drawable).getCurrent(), button, bitmap, rect) : (drawable2 instanceof LayerDrawable ? this.getLayerDrawableColor((LayerDrawable)drawable, button, bitmap, rect) : button.getCurrentTextColor()))));
    }

    private final int getLayerDrawableColor(LayerDrawable drawable, Button button, Bitmap bitmap, Rect rect) {
        int n = drawable.getNumberOfLayers();
        for (int i = 0; i < n; ++i) {
            Drawable layer = drawable.getDrawable(i);
            if (!layer.isVisible()) continue;
            return this.getButtonDrawableColor(layer, button, bitmap, rect);
        }
        return button.getCurrentTextColor();
    }

    private final int getBitmapDrawableColor(BitmapDrawable drawable) {
        Bitmap bitmap = drawable.getBitmap();
        Palette palette = Palette.from((Bitmap)bitmap).generate();
        Intrinsics.checkNotNullExpressionValue((Object)palette, (String)"generate(...)");
        Palette palette2 = palette;
        return palette2.getMutedColor(-16777216);
    }

    private final Bitmap crop(Bitmap $this$crop, Rect rect) {
        Rect safeRect = this.getSafeRect(rect, $this$crop);
        int width = safeRect.width();
        int height = safeRect.height();
        if (width <= 0 || height <= 0) {
            return null;
        }
        return this.isSameSize($this$crop, safeRect) ? $this$crop : Bitmap.createBitmap((Bitmap)$this$crop, (int)safeRect.left, (int)safeRect.top, (int)width, (int)height);
    }

    private final boolean isSameSize(Bitmap $this$isSameSize, Rect rect) {
        return rect.width() == $this$isSameSize.getWidth() && rect.height() == $this$isSameSize.getHeight() && rect.left == 0 && rect.top == 0;
    }

    private final Rect getSafeRect(Rect $this$getSafeRect, Bitmap bitmap) {
        return new Rect(RangesKt.coerceAtLeast((int)$this$getSafeRect.left, (int)0), RangesKt.coerceAtLeast((int)$this$getSafeRect.top, (int)0), RangesKt.coerceAtMost((int)$this$getSafeRect.right, (int)bitmap.getWidth()), RangesKt.coerceAtMost((int)$this$getSafeRect.bottom, (int)bitmap.getHeight()));
    }
}

