/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot.masking;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.dynatrace.android.sessionreplay.tracking.TrackingConfigurationHolder;
import com.dynatrace.android.sessionreplay.tracking.helpers.DividedRectangles;
import com.dynatrace.android.sessionreplay.tracking.helpers.OcclusionHandler;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskedArea;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskedAreaKt;
import com.dynatrace.android.sessionreplay.tracking.validator.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ$\u0010\n\u001a\f\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/NativeMaskingAreasProvider;", "", "configHolder", "Lcom/dynatrace/android/sessionreplay/tracking/TrackingConfigurationHolder;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;", "Landroid/view/View;", "occlusionHandler", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "(Lcom/dynatrace/android/sessionreplay/tracking/TrackingConfigurationHolder;Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;)V", "getMaskedAreas", "", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedArea;", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedAreas;", "view", "bitmap", "Landroid/graphics/Bitmap;", "isMasked", "", "needMasking", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nNativeMaskingAreasProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeMaskingAreasProvider.kt\ncom/dynatrace/android/sessionreplay/tracking/screenshot/masking/NativeMaskingAreasProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,72:1\n1855#2,2:73\n2624#2,3:75\n*S KotlinDebug\n*F\n+ 1 NativeMaskingAreasProvider.kt\ncom/dynatrace/android/sessionreplay/tracking/screenshot/masking/NativeMaskingAreasProvider\n*L\n37#1:73,2\n66#1:75,3\n*E\n"})
public final class NativeMaskingAreasProvider {
    @NotNull
    private final TrackingConfigurationHolder configHolder;
    @NotNull
    private final Validation<View> maskingValidator;
    @NotNull
    private final OcclusionHandler occlusionHandler;

    public NativeMaskingAreasProvider(@NotNull TrackingConfigurationHolder configHolder, @NotNull Validation<? super View> maskingValidator, @NotNull OcclusionHandler occlusionHandler) {
        Intrinsics.checkNotNullParameter((Object)configHolder, (String)"configHolder");
        Intrinsics.checkNotNullParameter(maskingValidator, (String)"maskingValidator");
        Intrinsics.checkNotNullParameter((Object)occlusionHandler, (String)"occlusionHandler");
        this.configHolder = configHolder;
        this.maskingValidator = maskingValidator;
        this.occlusionHandler = occlusionHandler;
    }

    @NotNull
    public final List<MaskedArea> getMaskedAreas(@NotNull View view, @Nullable Bitmap bitmap) {
        List maskedAreas;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                if (!this.needMasking(view)) {
                    return CollectionsKt.emptyList();
                }
                maskedAreas = new ArrayList();
                if (!this.isMasked(view)) break block6;
                if (view.getVisibility() != 0) {
                    return maskedAreas;
                }
                DividedRectangles frames = this.occlusionHandler.getVisibleFrames(view);
                Iterable $this$forEach$iv = frames.getRectangles();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    int n;
                    Rect rect = (Rect)element$iv;
                    boolean bl = false;
                    if (this.configHolder.isColorMaskingEnabled()) {
                        Bitmap bitmap2 = bitmap;
                        n = bitmap2 != null ? MaskedAreaKt.getDominantColor(bitmap2, view, rect) : -16777216;
                    } else {
                        n = -16777216;
                    }
                    int color = n;
                    maskedAreas.add(new MaskedArea(rect, color));
                }
                break block7;
            }
            if (!(view instanceof ViewGroup)) break block7;
            int n = ((ViewGroup)view).getChildCount();
            for (int index = 0; index < n; ++index) {
                Collection collection = maskedAreas;
                View view2 = ((ViewGroup)view).getChildAt(index);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getChildAt(...)");
                CollectionsKt.addAll((Collection)collection, (Iterable)this.getMaskedAreas(view2, bitmap));
            }
        }
        return maskedAreas;
    }

    public static /* synthetic */ List getMaskedAreas$default(NativeMaskingAreasProvider nativeMaskingAreasProvider, View view, Bitmap bitmap, int n, Object object) {
        if ((n & 2) != 0) {
            bitmap = null;
        }
        return nativeMaskingAreasProvider.getMaskedAreas(view, bitmap);
    }

    private final boolean isMasked(View view) {
        return this.maskingValidator.validate(view);
    }

    private final boolean needMasking(View $this$needMasking) {
        return true;
    }
}

