/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.CompoundButtonMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/CompoundButtonTracker;", "", "observer", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "getAction", "Lcom/dynatrace/android/sessionreplay/tracking/model/CompoundButtonMetadata$Action;", "masked", "", "checked", "trackCompoundButtonStateChanged", "", "viewHolder", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackinglayer_release"})
public final class CompoundButtonTracker {
    @NotNull
    private final TrackingObserver observer;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public CompoundButtonTracker(@NotNull TrackingObserver observer, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.observer = observer;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackCompoundButtonStateChanged(boolean checked, @NotNull UIView viewHolder) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) break block2;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            boolean masked = this.maskingValidator.validate(view2);
            DTLogger.INSTANCE.tracking("trackCompoundButtonStateChanged with value: " + checked + " and the view is: " + (masked ? "masked" : "not masked"));
            CompoundButtonMetadata.Action action = this.getAction(masked, checked);
            CompoundButtonMetadata eventMetaData = new CompoundButtonMetadata(action);
            if (masked) {
                this.observer.onCompoundStateChanged(new Date(), viewMetadata, this.maskingValidator.validate(view2), eventMetaData, null);
            } else {
                this.screenshotHandler.takeScreenshot(viewHolder, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, viewMetadata, view2, eventMetaData){
                    final /* synthetic */ CompoundButtonTracker this$0;
                    final /* synthetic */ ViewMetadata $viewMetadata;
                    final /* synthetic */ View $view;
                    final /* synthetic */ CompoundButtonMetadata $eventMetaData;
                    {
                        this.this$0 = $receiver;
                        this.$viewMetadata = $viewMetadata;
                        this.$view = $view;
                        this.$eventMetaData = $eventMetaData;
                        super(1);
                    }

                    public final void invoke(@Nullable Bitmap bitmap) {
                        CompoundButtonTracker.access$getObserver$p(this.this$0).onCompoundStateChanged(new Date(), this.$viewMetadata, CompoundButtonTracker.access$getMaskingValidator$p(this.this$0).validate(this.$view), this.$eventMetaData, bitmap);
                    }
                }));
            }
        }
    }

    private final CompoundButtonMetadata.Action getAction(boolean masked, boolean checked) {
        CompoundButtonMetadata.Action action;
        if (masked) {
            action = CompoundButtonMetadata.Action.UNDEFINED;
        } else {
            boolean bl = checked;
            if (bl) {
                action = CompoundButtonMetadata.Action.ON;
            } else if (!bl) {
                action = CompoundButtonMetadata.Action.OFF;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return action;
    }

    public static final /* synthetic */ TrackingObserver access$getObserver$p(CompoundButtonTracker $this) {
        return $this.observer;
    }

    public static final /* synthetic */ MaskingValidator access$getMaskingValidator$p(CompoundButtonTracker $this) {
        return $this.maskingValidator;
    }
}

