/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.ScrollMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/ScrollTracker;", "", "scrollObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "trackScroll", "", "viewHolder", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "deltaX", "", "deltaY", "scrollX", "scrollY", "oldScrollX", "oldScrollY", "trackinglayer_release"})
public final class ScrollTracker {
    @Nullable
    private final TrackingObserver scrollObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public ScrollTracker(@Nullable TrackingObserver scrollObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.scrollObserver = scrollObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackScroll(@NotNull UIView viewHolder, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        int deltaX = scrollX - oldScrollX;
        int deltaY = scrollY - oldScrollY;
        this.trackScroll(viewHolder, deltaX, deltaY);
    }

    public final void trackScroll(@NotNull UIView viewHolder, int deltaX, int deltaY) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            if (this.scrollObserver == null) {
                return;
            }
            View view = viewHolder.getContainerView();
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            this.screenshotHandler.takeScreenshot(viewHolder, (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(this, viewMetadata, view2, deltaX, deltaY){
                final /* synthetic */ ScrollTracker this$0;
                final /* synthetic */ ViewMetadata $viewMetadata;
                final /* synthetic */ View $view;
                final /* synthetic */ int $deltaX;
                final /* synthetic */ int $deltaY;
                {
                    this.this$0 = $receiver;
                    this.$viewMetadata = $viewMetadata;
                    this.$view = $view;
                    this.$deltaX = $deltaX;
                    this.$deltaY = $deltaY;
                    super(1);
                }

                public final void invoke(@Nullable Bitmap bitmap) {
                    ScrollTracker.access$getScrollObserver$p(this.this$0).onScroll(new Date(), this.$viewMetadata, ScrollTracker.access$getMaskingValidator$p(this.this$0).validate(this.$view), new ScrollMetadata(this.$deltaX, this.$deltaY), bitmap);
                }
            }));
        }
    }

    public static final /* synthetic */ TrackingObserver access$getScrollObserver$p(ScrollTracker $this) {
        return $this.scrollObserver;
    }

    public static final /* synthetic */ MaskingValidator access$getMaskingValidator$p(ScrollTracker $this) {
        return $this.maskingValidator;
    }
}

