/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import com.dynatrace.android.sessionreplay.tracking.model.CheckpointMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.GestureMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.TouchMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIKeyEvent;
import com.dynatrace.android.sessionreplay.tracking.model.UIMotionEvent;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0015\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0015R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u00060\bR\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/WindowActionTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;)V", "pointers", "", "", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/WindowActionTracker$Pointer;", "actionDown", "", "event", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIMotionEvent;", "pointerIndex", "eventPointerId", "actionMove", "actionUp", "trackKey", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIKeyEvent;", "trackKey$trackinglayer_release", "trackTouch", "trackTouch$trackinglayer_release", "Companion", "Pointer", "trackinglayer_release"})
public final class WindowActionTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final Map<Integer, Pointer> pointers;
    public static final int MINIMUM_DISTANCE = 50;

    public WindowActionTracker(@NotNull TrackingObserver trackingObserver) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        this.trackingObserver = trackingObserver;
        this.pointers = new LinkedHashMap();
    }

    public final void trackKey$trackinglayer_release(@NotNull UIKeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)new Pair((Object)event.getKeyCode(), (Object)event.getAction()), (Object)new Pair((Object)4, (Object)1))) {
            return;
        }
        this.trackingObserver.onBackNavigation(new Date());
    }

    public final void trackTouch$trackinglayer_release(@NotNull UIMotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int pointerIndex = event.getActionIndex();
        int eventPointerId = event.getPointerId(pointerIndex);
        switch (event.getActionMasked()) {
            case 0: {
                this.actionDown(event, pointerIndex, eventPointerId);
                break;
            }
            case 2: {
                this.actionMove(event);
                break;
            }
            case 1: {
                this.actionUp(event, pointerIndex, eventPointerId);
                this.pointers.clear();
                break;
            }
            case 5: {
                this.actionDown(event, pointerIndex, eventPointerId);
                break;
            }
            case 6: {
                this.actionUp(event, pointerIndex, eventPointerId);
                this.pointers.remove(eventPointerId);
            }
        }
    }

    private final void actionDown(UIMotionEvent event, int pointerIndex, int eventPointerId) {
        Pointer pointer = new Pointer(new CheckpointMetadata(new Date().getTime(), (int)event.getX(pointerIndex), (int)event.getY(pointerIndex)));
        Integer n = eventPointerId;
        this.pointers.put(n, pointer);
    }

    private final void actionMove(UIMotionEvent event) {
        int n = event.getPointerCount();
        for (int pointerIdx = 0; pointerIdx < n; ++pointerIdx) {
            Pointer pointer;
            if (event.getHistorySize() <= 0) continue;
            int eventX = (int)event.getX(pointerIdx);
            int eventHistoricalX = (int)event.getHistoricalX(pointerIdx);
            int eventY = (int)event.getY(pointerIdx);
            int eventHistoricalY = (int)event.getHistoricalY(pointerIdx);
            if (eventX == eventHistoricalX && eventY == eventHistoricalY) continue;
            Pointer pointer2 = pointer = this.pointers.get(event.getPointerId(pointerIdx));
            if (pointer2 == null) continue;
            pointer2.processMoveEvent$trackinglayer_release(event, pointerIdx);
        }
    }

    private final void actionUp(UIMotionEvent event, int pointerIndex, int eventPointerId) {
        Pointer pointer = this.pointers.get(eventPointerId);
        if (pointer == null) {
            return;
        }
        pointer.getCheckpoints$trackinglayer_release().add(new CheckpointMetadata(new Date().getTime(), (int)event.getX(pointerIndex), (int)event.getY(pointerIndex)));
        if (pointer.getCheckpoints$trackinglayer_release().size() == 2) {
            Date startDate = new Date(new Date().getTime() - pointer.getDuration$trackinglayer_release());
            this.trackingObserver.onTouch(startDate, event.getEventTime(), new TouchMetadata(pointer.getDuration$trackinglayer_release(), (int)event.getX(pointerIndex), (int)event.getY(pointerIndex)));
        } else {
            this.trackingObserver.onGesture(new Date(((CheckpointMetadata)CollectionsKt.first(pointer.getCheckpoints$trackinglayer_release())).getTime()), new GestureMetadata(pointer.getCheckpoints$trackinglayer_release()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/WindowActionTracker$Companion;", "", "()V", "MINIMUM_DISTANCE", "", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001cJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/WindowActionTracker$Pointer;", "", "firstCheckpoint", "Lcom/dynatrace/android/sessionreplay/tracking/model/CheckpointMetadata;", "(Lcom/dynatrace/android/sessionreplay/tracking/trackers/WindowActionTracker;Lcom/dynatrace/android/sessionreplay/tracking/model/CheckpointMetadata;)V", "checkpoints", "", "getCheckpoints$trackinglayer_release", "()Ljava/util/List;", "setCheckpoints$trackinglayer_release", "(Ljava/util/List;)V", "duration", "", "getDuration$trackinglayer_release", "()J", "minimumDistanceThreshold", "", "calculateDistance", "", "previousCheckpoint", "posX", "", "posY", "processMoveEvent", "", "event", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIMotionEvent;", "pointerIdx", "processMoveEvent$trackinglayer_release", "shouldTrackCurrentCheckpoint", "", "trackinglayer_release"})
    private final class Pointer {
        private final int minimumDistanceThreshold;
        @NotNull
        private List<CheckpointMetadata> checkpoints;

        public Pointer(CheckpointMetadata firstCheckpoint) {
            Intrinsics.checkNotNullParameter((Object)firstCheckpoint, (String)"firstCheckpoint");
            this.minimumDistanceThreshold = 50;
            this.checkpoints = new ArrayList();
            this.checkpoints.add(firstCheckpoint);
        }

        @NotNull
        public final List<CheckpointMetadata> getCheckpoints$trackinglayer_release() {
            return this.checkpoints;
        }

        public final void setCheckpoints$trackinglayer_release(@NotNull List<CheckpointMetadata> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.checkpoints = list;
        }

        public final long getDuration$trackinglayer_release() {
            return ((CheckpointMetadata)CollectionsKt.last(this.checkpoints)).getTime() - ((CheckpointMetadata)CollectionsKt.first(this.checkpoints)).getTime();
        }

        public final void processMoveEvent$trackinglayer_release(@NotNull UIMotionEvent event, int pointerIdx) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            float posX = event.getX(pointerIdx);
            float posY = event.getY(pointerIdx);
            if (this.shouldTrackCurrentCheckpoint(posX, posY)) {
                CheckpointMetadata checkpoint = new CheckpointMetadata(new Date().getTime(), (int)posX, (int)posY);
                this.checkpoints.add(checkpoint);
            }
        }

        private final boolean shouldTrackCurrentCheckpoint(float posX, float posY) {
            double distance = this.calculateDistance((CheckpointMetadata)CollectionsKt.last(this.checkpoints), posX, posY);
            return distance >= (double)this.minimumDistanceThreshold;
        }

        private final double calculateDistance(CheckpointMetadata previousCheckpoint, float posX, float posY) {
            return Math.sqrt(Math.pow((float)previousCheckpoint.getX() - posX, 2.0) + Math.pow((float)previousCheckpoint.getY() - posY, 2.0));
        }
    }
}

