/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.os.Build;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\n\u0010\u0000\u001a\u0004\u0018\u00010\u0001H\u0001\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0001H\u0000\u00a8\u0006\u0006"}, d2={"getRunningActivityByReflection", "Landroid/app/Activity;", "getRootView", "Landroid/view/ViewGroup;", "getScreenRotation", "", "trackinglayer_release"})
public final class ActivityUtilsKt {
    @NotNull
    public static final ViewGroup getRootView(@NotNull Activity $this$getRootView) {
        Intrinsics.checkNotNullParameter((Object)$this$getRootView, (String)"<this>");
        View view = $this$getRootView.findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        return (ViewGroup)view;
    }

    public static final int getScreenRotation(@NotNull Activity $this$getScreenRotation) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getScreenRotation, (String)"<this>");
        if (Build.VERSION.SDK_INT <= 29) {
            n = $this$getScreenRotation.getWindowManager().getDefaultDisplay().getRotation();
        } else {
            Display display = $this$getScreenRotation.getDisplay();
            n = display != null ? display.getRotation() : 0;
        }
        return n;
    }

    @SuppressLint(value={"PrivateApi"})
    @Nullable
    public static final Activity getRunningActivityByReflection() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field field = activityThreadClass.getDeclaredField("mActivities");
            Intrinsics.checkNotNullExpressionValue((Object)field, (String)"getDeclaredField(...)");
            Field activitiesField = field;
            activitiesField.setAccessible(true);
            Object object = activitiesField.get(activityThread);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
            Map activities = (Map)object;
            Iterator iterator = activities.values().iterator();
            while (iterator.hasNext()) {
                Field pausedField;
                Object activityClientRecord;
                Object v = activityClientRecord = iterator.next();
                Intrinsics.checkNotNull(v);
                Class<?> activityClientRecordClass = v.getClass();
                Intrinsics.checkNotNullExpressionValue((Object)activityClientRecordClass.getDeclaredField("paused"), (String)"getDeclaredField(...)");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityClientRecord)) continue;
                Field field2 = activityClientRecordClass.getDeclaredField("activity");
                Intrinsics.checkNotNullExpressionValue((Object)field2, (String)"getDeclaredField(...)");
                Field activityField = field2;
                activityField.setAccessible(true);
                Object object2 = activityField.get(activityClientRecord);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type android.app.Activity");
                return (Activity)object2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

