/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.validator.masking.rules;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.dynatrace.android.sessionreplay.tracking.validator.Validation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\t\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/rules/SecuredViewValidator;", "Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;", "Landroid/view/View;", "()V", "validate", "", "subject", "isSecuredTextInputLayout", "isSecuredTextView", "isTextInputLayout", "shifted4", "", "trackinglayer_release"})
public final class SecuredViewValidator
implements Validation<View> {
    @Override
    public boolean validate(@NotNull View subject) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        return this.isSecuredTextView(subject) || this.isSecuredTextInputLayout(subject);
    }

    private final boolean isSecuredTextInputLayout(View $this$isSecuredTextInputLayout) {
        if (!this.isTextInputLayout($this$isSecuredTextInputLayout)) {
            return false;
        }
        boolean isSecuredTextInputLayout = false;
        try {
            FrameLayout frameLayout;
            Intrinsics.checkNotNull((Object)$this$isSecuredTextInputLayout, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            View view = ((ViewGroup)$this$isSecuredTextInputLayout).getChildAt(0);
            FrameLayout frameLayout2 = frameLayout = view instanceof FrameLayout ? (FrameLayout)view : null;
            if (frameLayout2 != null) {
                FrameLayout it = frameLayout2;
                boolean bl = false;
                int n = frameLayout.getChildCount();
                for (int i = 0; i < n; ++i) {
                    View view2 = frameLayout.getChildAt(i);
                    Intrinsics.checkNotNull((Object)view2);
                    isSecuredTextInputLayout = this.isSecuredTextView(view2) || isSecuredTextInputLayout;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return isSecuredTextInputLayout;
    }

    private final boolean isTextInputLayout(View $this$isTextInputLayout) {
        try {
            boolean isEmpty;
            Intrinsics.checkNotNull((Object)$this$isTextInputLayout, (String)"null cannot be cast to non-null type android.view.ViewGroup");
            boolean bl = isEmpty = ((ViewGroup)$this$isTextInputLayout).getChildCount() == 0;
            if (!Intrinsics.areEqual((Object)$this$isTextInputLayout.getClass().getName(), (Object)"com.google.android.material.textfield.TextInputLayout") || isEmpty) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private final boolean isSecuredTextView(View $this$isSecuredTextView) {
        if (!($this$isSecuredTextView instanceof TextView)) {
            return false;
        }
        int shiftedType = this.shifted4(((TextView)$this$isSecuredTextView).getInputType());
        boolean isTxtPassword = shiftedType == this.shifted4(128) || shiftedType == this.shifted4(144);
        boolean isNumPassword = shiftedType == this.shifted4(16);
        boolean isWebPassword = shiftedType == this.shifted4(224);
        return isTxtPassword || isNumPassword || isWebPassword;
    }

    private final int shifted4(int $this$shifted4) {
        return $this$shifted4 >> 4;
    }
}

