/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.validator.screenshot.rules;

import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.helpers.OcclusionHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.Validation;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\b\u0010\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0004J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/validator/screenshot/rules/ScreenshotViewRule;", "Lcom/dynatrace/android/sessionreplay/tracking/validator/Validation;", "Landroid/view/View;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "occlusionHandler", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;", "(Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;Lcom/dynatrace/android/sessionreplay/tracking/helpers/OcclusionHandler;)V", "hasVisibleVisibility", "", "view", "isMasked", "isOccluded", "isOnScreen", "isTransparent", "isVisible", "shouldTakeScreenshot", "validate", "subject", "trackinglayer_release"})
public class ScreenshotViewRule
implements Validation<View> {
    @NotNull
    private final MaskingValidator maskingValidator;
    @NotNull
    private final OcclusionHandler occlusionHandler;

    public ScreenshotViewRule(@NotNull MaskingValidator maskingValidator, @NotNull OcclusionHandler occlusionHandler) {
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        Intrinsics.checkNotNullParameter((Object)occlusionHandler, (String)"occlusionHandler");
        this.maskingValidator = maskingValidator;
        this.occlusionHandler = occlusionHandler;
    }

    @Override
    public boolean validate(@NotNull View subject) {
        Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
        return this.shouldTakeScreenshot(subject);
    }

    protected final boolean shouldTakeScreenshot(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        boolean visible = this.isVisible(view);
        boolean masked = this.isMasked(view);
        return visible && !masked;
    }

    private final boolean isVisible(View view) {
        boolean hasVisibleVisibility = this.hasVisibleVisibility(view);
        boolean transparent = this.isTransparent(view);
        boolean onScreen = this.isOnScreen(view);
        boolean occluded = this.isOccluded(view);
        return hasVisibleVisibility && !transparent && onScreen && !occluded;
    }

    private final boolean hasVisibleVisibility(View view) {
        boolean isVisible;
        boolean bl = isVisible = view.getVisibility() == 0;
        if (!isVisible) {
            DTLogger.INSTANCE.tracking("Record validation: invisible for " + view);
        }
        return isVisible;
    }

    private final boolean isOccluded(View view) {
        boolean isOccluded = this.occlusionHandler.getVisibleFrames(view).isEmpty();
        if (isOccluded) {
            DTLogger.INSTANCE.tracking("Record validation: occlusion for " + view);
        }
        return isOccluded;
    }

    private final boolean isTransparent(View view) {
        boolean isTransparent;
        boolean bl = isTransparent = view.getAlpha() <= 0.0f;
        if (isTransparent) {
            DTLogger.INSTANCE.tracking("Record validation: transparent for " + view);
        }
        return isTransparent;
    }

    private final boolean isOnScreen(View view) {
        boolean isOnScreen;
        View rootView = view.getRootView();
        int[] nArray = ViewExtensionsKt.getLocation(view);
        int x = nArray[0];
        int y = nArray[1];
        boolean bl = isOnScreen = x < rootView.getWidth() && y < rootView.getHeight() && x + view.getWidth() > 0 && y + view.getHeight() > 0;
        if (!isOnScreen) {
            DTLogger.INSTANCE.tracking("Record validation: out of screen for " + view);
        }
        return isOnScreen;
    }

    private final boolean isMasked(View view) {
        return this.maskingValidator.validate(view);
    }
}

