/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.screenshot;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugBitmapHelper;
import com.dynatrace.android.sessionreplay.tracking.helpers.DebugOverlay;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandlerUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskedArea;
import com.dynatrace.android.sessionreplay.tracking.screenshot.masking.MaskingHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u001e\u0010\u0002\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ComposeScreenshotHandler;", "", "composeMaskingHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;", "", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedArea;", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskedAreas;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/screenshot/masking/MaskingHandler;)V", "composeMaskedAreas", "takeScreenshot", "Landroid/graphics/Bitmap;", "uiComposeView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIComposeView;", "getPartialBitmap", "getRootBitmap", "view", "Landroid/view/View;", "drawPartialBitmapUnCropped", "trackinglayer_release"})
public final class ComposeScreenshotHandler {
    @NotNull
    private final MaskingHandler<List<MaskedArea>> composeMaskingHandler;
    @NotNull
    private List<MaskedArea> composeMaskedAreas;

    public ComposeScreenshotHandler(@NotNull MaskingHandler<List<MaskedArea>> composeMaskingHandler) {
        Intrinsics.checkNotNullParameter(composeMaskingHandler, (String)"composeMaskingHandler");
        this.composeMaskingHandler = composeMaskingHandler;
        this.composeMaskedAreas = CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bitmap takeScreenshot(@NotNull UIComposeView uiComposeView) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)uiComposeView, (String)"uiComposeView");
        this.composeMaskedAreas = CollectionsKt.toList((Iterable)uiComposeView.getMaskedAreas());
        View view = uiComposeView.getContainerView();
        if (view == null || view.getWidth() <= 0 || view.getHeight() <= 0) {
            View view2 = view;
            View view3 = view;
            DTLogger.INSTANCE.tracking("Record: no view or no size with view=" + view + " and " + (view2 != null ? Integer.valueOf(view2.getWidth()) : null) + 'x' + (view3 != null ? Integer.valueOf(view3.getHeight()) : null));
            return null;
        }
        Bitmap bitmap2 = this.getPartialBitmap(uiComposeView);
        if (bitmap2 != null) {
            void var3_3;
            Bitmap bitmap3 = bitmap2;
            boolean bl = false;
            DebugBitmapHelper.INSTANCE.saveBitmap$trackinglayer_release(view, bitmap3);
            DebugOverlay.INSTANCE.showDebugOverlay(uiComposeView, bitmap3);
            bitmap = var3_3;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    private final Bitmap getPartialBitmap(UIComposeView uiComposeView) {
        ViewMetadata viewMetadata = uiComposeView.getMetadata();
        if (viewMetadata.getViewWidth() <= 0 || viewMetadata.getViewHeight() <= 0) {
            DTLogger.INSTANCE.tracking("Record: invalid view metadata");
            return null;
        }
        return this.drawPartialBitmapUnCropped(uiComposeView);
    }

    private final Bitmap getRootBitmap(View view) {
        Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap rootBitmap = bitmap;
        Canvas rootCanvas = new Canvas(rootBitmap);
        try {
            view.draw(rootCanvas);
        }
        catch (Exception e) {
            DTLogger.INSTANCE.error("Screenshot: Is not possible to get a screenshot: " + e.getLocalizedMessage());
        }
        MaskingHandler.mask$default(this.composeMaskingHandler, this.composeMaskedAreas, rootCanvas, null, 4, null);
        return rootBitmap;
    }

    private final Bitmap drawPartialBitmapUnCropped(UIComposeView uiComposeView) {
        Bitmap bitmap;
        View view = uiComposeView.getContainerView();
        if (view == null || (view = view.getRootView()) == null) {
            ComposeScreenshotHandler $this$drawPartialBitmapUnCropped_u24lambda_u241 = this;
            boolean bl = false;
            DTLogger.INSTANCE.tracking("Draw partial: invalid compose view container, no rootView");
            return null;
        }
        View rootView = view;
        Bitmap rootBitmap = this.getRootBitmap(rootView);
        ViewMetadata viewMetadata = uiComposeView.getMetadata();
        Pair<Integer, Integer> pair = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewMetadata.getPositionX(), viewMetadata.getViewWidth(), rootBitmap.getWidth());
        int x = ((Number)pair.component1()).intValue();
        int width = ((Number)pair.component2()).intValue();
        Pair<Integer, Integer> pair2 = ScreenshotHandlerUtilsKt.calculateBoundsInScreen(viewMetadata.getPositionY(), viewMetadata.getViewHeight(), rootBitmap.getHeight());
        int y = ((Number)pair2.component1()).intValue();
        int height = ((Number)pair2.component2()).intValue();
        if (width <= 0 || height <= 0) {
            DTLogger.INSTANCE.tracking("Record: invalid size " + width + 'x' + height);
            bitmap = null;
        } else {
            bitmap = Bitmap.createBitmap((Bitmap)rootBitmap, (int)x, (int)y, (int)width, (int)height);
        }
        return bitmap;
    }
}

