/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.listeners.UIState;
import com.dynatrace.android.sessionreplay.tracking.model.CustomMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/CustomEventTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "uiState", "Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/listeners/UIState;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;)V", "trackCustomFull", "", "name", "", "trackCustomPartial", "view", "Landroid/view/View;", "trackCustomArea", "area", "Landroid/graphics/Rect;", "trackView", "uiView", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "logNoActivityFound", "trackinglayer_release"})
public final class CustomEventTracker {
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final UIState uiState;
    @NotNull
    private final ScreenshotHandler screenshotHandler;

    public CustomEventTracker(@NotNull TrackingObserver trackingObserver, @NotNull UIState uiState, @NotNull ScreenshotHandler screenshotHandler) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)uiState, (String)"uiState");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        this.trackingObserver = trackingObserver;
        this.uiState = uiState;
        this.screenshotHandler = screenshotHandler;
    }

    public final void trackCustomFull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        UIView uIView = this.uiState.getCurrentView();
        if (uIView != null) {
            UIView fullUIView = uIView;
            boolean bl = false;
            this.trackView(name, fullUIView);
        } else {
            CustomEventTracker $this$trackCustomFull_u24lambda_u241 = this;
            boolean bl = false;
            $this$trackCustomFull_u24lambda_u241.logNoActivityFound();
        }
    }

    public final void trackCustomPartial(@NotNull String name, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.trackView(name, new UIView(view, null, null, 6, null));
    }

    public final void trackCustomArea(@NotNull String name, @NotNull Rect area) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        UIView uIView = this.uiState.getCurrentView();
        if (uIView != null) {
            UIView fullUIView = uIView;
            boolean bl = false;
            ViewMetadata viewMetadata = fullUIView.getMetadata();
            if (viewMetadata == null) {
                CustomEventTracker $this$trackCustomArea_u24lambda_u244_u24lambda_u242 = this;
                boolean bl2 = false;
                $this$trackCustomArea_u24lambda_u244_u24lambda_u242.logNoActivityFound();
                return;
            }
            ViewMetadata viewMetadata2 = viewMetadata;
            this.screenshotHandler.takeAreaScreenshot(fullUIView, area, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> CustomEventTracker.trackCustomArea$lambda$4$lambda$3(this, name, viewMetadata2, arg_0)));
        } else {
            CustomEventTracker $this$trackCustomArea_u24lambda_u245 = this;
            boolean bl = false;
            $this$trackCustomArea_u24lambda_u245.logNoActivityFound();
        }
    }

    private final void trackView(String name, UIView uiView) {
        ViewMetadata viewMetadata = uiView.getMetadata();
        if (viewMetadata == null) {
            return;
        }
        ViewMetadata viewMetadata2 = viewMetadata;
        this.screenshotHandler.takeScreenshot(uiView, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> CustomEventTracker.trackView$lambda$6(this, name, viewMetadata2, arg_0)));
    }

    private final void logNoActivityFound() {
        DTLogger.INSTANCE.error("Error trying to track a custom event -> no activity found");
    }

    private static final Unit trackCustomArea$lambda$4$lambda$3(CustomEventTracker this$0, String $name, ViewMetadata $viewMetadata, Bitmap bitmap) {
        TrackingObserver trackingObserver = this$0.trackingObserver;
        Date date = new Date();
        CustomMetadata customMetadata = new CustomMetadata($name);
        trackingObserver.onCustom(date, $viewMetadata, false, customMetadata, bitmap);
        return Unit.INSTANCE;
    }

    private static final Unit trackView$lambda$6(CustomEventTracker this$0, String $name, ViewMetadata $viewMetadata, Bitmap bitmap) {
        TrackingObserver trackingObserver = this$0.trackingObserver;
        Date date = new Date();
        CustomMetadata customMetadata = new CustomMetadata($name);
        trackingObserver.onCustom(date, $viewMetadata, false, customMetadata, bitmap);
        return Unit.INSTANCE;
    }
}

