/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl;

import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.EditText;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.interceptors.AbsListViewScrollInterceptor;
import com.dynatrace.android.sessionreplay.tracking.interceptors.InterceptorFactory;
import com.dynatrace.android.sessionreplay.tracking.interceptors.ViewInterceptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0012\u0010\n\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/ViewGroupInterceptor;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/ViewInterceptor;", "Landroid/view/ViewGroup;", "interceptorFactory", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/InterceptorFactory;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/interceptors/InterceptorFactory;)V", "interceptView", "", "view", "processView", "Landroid/view/View;", "isScrollingView", "", "interceptScrollingView", "scrollingView", "interceptListView", "Landroid/widget/AbsListView;", "interceptEditText", "editText", "Landroid/widget/EditText;", "trackinglayer_release"})
public final class ViewGroupInterceptor
implements ViewInterceptor<ViewGroup> {
    @NotNull
    private final InterceptorFactory interceptorFactory;

    public ViewGroupInterceptor(@NotNull InterceptorFactory interceptorFactory) {
        Intrinsics.checkNotNullParameter((Object)interceptorFactory, (String)"interceptorFactory");
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public void interceptView(@NotNull ViewGroup view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.processView((View)view);
    }

    private final void processView(View view) {
        if (view == null) {
            return;
        }
        if (view instanceof EditText) {
            this.interceptEditText((EditText)view);
            return;
        }
        if (this.isScrollingView(view)) {
            this.interceptScrollingView(view);
        } else if (view instanceof AbsListView) {
            this.interceptListView((AbsListView)view);
        }
        if (view instanceof ViewGroup) {
            int n = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = ((ViewGroup)view).getChildAt(i);
                this.processView(child);
            }
        }
    }

    private final boolean isScrollingView(View view) {
        View view2 = view;
        return view2 instanceof HorizontalScrollView || view2 instanceof ScrollView;
    }

    private final void interceptScrollingView(View scrollingView) {
        DTLogger.INSTANCE.tracking("Intercepting scrolling view: " + scrollingView);
        this.interceptorFactory.getViewScrollViewInterceptor().interceptView(scrollingView);
    }

    private final void interceptListView(AbsListView view) {
        DTLogger.INSTANCE.tracking("Intercepting list view: " + view);
        AbsListViewScrollInterceptor.DefaultImpls.interceptListView$default(this.interceptorFactory.getListViewScrollInterceptor(), view, null, false, 6, null);
    }

    private final void interceptEditText(EditText editText) {
        DTLogger.INSTANCE.tracking("Intercepting Edit text: " + editText);
        this.interceptorFactory.getEditTextInterceptor().interceptView((EditText)((View)editText));
    }
}

