/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl.fragments;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.dynatrace.android.sessionreplay.tracking.interceptors.FragmentInterceptor;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.fragments.OnFragmentAnimationEndListener;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.fragments.OnFragmentAnimatorEndListener;
import com.dynatrace.android.sessionreplay.tracking.utils.InterceptionCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J2\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J2\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000bH\u0002J\u001a\u0010\u001e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020\u0014H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/fragments/FragmentInterceptorImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/FragmentInterceptor;", "Landroid/view/View;", "trackingHandler", "Lkotlin/Function2;", "", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "interceptedFragmentViews", "Lcom/dynatrace/android/sessionreplay/tracking/utils/InterceptionCache;", "", "interceptFragmentView", "fragment", "view", "interceptOnCreateFragmentAnimation", "Landroid/view/animation/Animation;", "transit", "", "enter", "", "nextAnim", "context", "Landroid/content/Context;", "interceptOnCreateFragmentAnimator", "Landroid/animation/Animator;", "addAnimationListener", "animation", "addAnimatorListener", "animator", "trackFragment", "withAfterMeasure", "trackinglayer_release"})
@SourceDebugExtension(value={"SMAP\nFragmentInterceptorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FragmentInterceptorImpl.kt\ncom/dynatrace/android/sessionreplay/tracking/interceptors/impl/fragments/FragmentInterceptorImpl\n+ 2 ViewExtensions.kt\ncom/dynatrace/android/sessionreplay/tracking/extensions/ViewExtensionsKt\n*L\n1#1,114:1\n29#2,9:115\n*S KotlinDebug\n*F\n+ 1 FragmentInterceptorImpl.kt\ncom/dynatrace/android/sessionreplay/tracking/interceptors/impl/fragments/FragmentInterceptorImpl\n*L\n107#1:115,9\n*E\n"})
public final class FragmentInterceptorImpl
implements FragmentInterceptor<View> {
    @NotNull
    private final Function2<View, String, Unit> trackingHandler;
    @NotNull
    private final InterceptionCache<Object, View> interceptedFragmentViews;

    public FragmentInterceptorImpl(@NotNull Function2<? super View, ? super String, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.trackingHandler = trackingHandler;
        this.interceptedFragmentViews = new InterceptionCache();
    }

    @Override
    public void interceptFragmentView(@NotNull Object fragment, @NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.interceptedFragmentViews.set(fragment, view);
    }

    @Override
    @Nullable
    public Animation interceptOnCreateFragmentAnimation(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (nextAnim == 0 || !enter) {
            return null;
        }
        String dir = context.getResources().getResourceTypeName(nextAnim);
        boolean isAnim = Intrinsics.areEqual((Object)"anim", (Object)dir);
        if (isAnim) {
            try {
                Animation animation = AnimationUtils.loadAnimation((Context)context, (int)nextAnim);
                if (animation != null) {
                    this.addAnimationListener(animation, fragment);
                    return animation;
                }
            }
            catch (Resources.NotFoundException notFoundException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Animator interceptOnCreateFragmentAnimator(@NotNull Object fragment, int transit, boolean enter, int nextAnim, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (nextAnim == 0 || !enter) {
            if (enter) {
                FragmentInterceptorImpl.trackFragment$default(this, fragment, false, 2, null);
            }
            return null;
        }
        try {
            Animator animator = AnimatorInflater.loadAnimator((Context)context, (int)nextAnim);
            if (animator != null) {
                this.addAnimatorListener(animator, fragment);
                return animator;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        FragmentInterceptorImpl.trackFragment$default(this, fragment, false, 2, null);
        return null;
    }

    private final void addAnimationListener(Animation animation, Object fragment) {
        animation.setAnimationListener((Animation.AnimationListener)new OnFragmentAnimationEndListener(fragment, (Function1<Object, Unit>)((Function1)arg_0 -> FragmentInterceptorImpl.addAnimationListener$lambda$0(this, arg_0))));
    }

    private final void addAnimatorListener(Animator animator, Object fragment) {
        animator.addListener((Animator.AnimatorListener)new OnFragmentAnimatorEndListener(fragment, (Function1<Object, Unit>)((Function1)arg_0 -> FragmentInterceptorImpl.addAnimatorListener$lambda$1(this, arg_0))));
    }

    private final void trackFragment(Object fragment, boolean withAfterMeasure) {
        block0: {
            View view;
            block1: {
                View view2 = this.interceptedFragmentViews.get(fragment);
                if (view2 == null) break block0;
                view = view2;
                boolean bl = false;
                if (view.getWidth() <= 0 || view.getHeight() <= 0) break block1;
                String string = fragment.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                this.trackingHandler.invoke((Object)view, (Object)string);
                break block0;
            }
            if (!withAfterMeasure) break block0;
            View $this$afterMeasured$iv = view;
            boolean $i$f$afterMeasured = false;
            $this$afterMeasured$iv.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener($this$afterMeasured$iv, this, fragment){
                final /* synthetic */ View $this_afterMeasured;
                final /* synthetic */ FragmentInterceptorImpl this$0;
                final /* synthetic */ Object $fragment$inlined;
                {
                    this.$this_afterMeasured = $receiver;
                    this.this$0 = fragmentInterceptorImpl;
                    this.$fragment$inlined = object;
                }

                public void onGlobalLayout() {
                    if (this.$this_afterMeasured.getMeasuredWidth() > 0 && this.$this_afterMeasured.getMeasuredHeight() > 0) {
                        this.$this_afterMeasured.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                        View $this$trackFragment_u24lambda_u243_u24lambda_u242 = this.$this_afterMeasured;
                        boolean bl = false;
                        FragmentInterceptorImpl.access$trackFragment(this.this$0, this.$fragment$inlined, false);
                    }
                }
            });
        }
    }

    static /* synthetic */ void trackFragment$default(FragmentInterceptorImpl fragmentInterceptorImpl, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        fragmentInterceptorImpl.trackFragment(object, bl);
    }

    private static final Unit addAnimationListener$lambda$0(FragmentInterceptorImpl this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FragmentInterceptorImpl.trackFragment$default(this$0, it, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final Unit addAnimatorListener$lambda$1(FragmentInterceptorImpl this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FragmentInterceptorImpl.trackFragment$default(this$0, it, false, 2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$trackFragment(FragmentInterceptorImpl $this, Object fragment, boolean withAfterMeasure) {
        $this.trackFragment(fragment, withAfterMeasure);
    }
}

