/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.interceptors.impl.webview;

import android.view.View;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.dynatrace.android.sessionreplay.tracking.helpers.WebViewClientProxy;
import com.dynatrace.android.sessionreplay.tracking.interceptors.WebLoadInterceptor;
import com.dynatrace.android.sessionreplay.tracking.interceptors.impl.webview.WebViewUtilsKt;
import com.dynatrace.android.sessionreplay.tracking.utils.InterceptionCache;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\fH\u0002R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/interceptors/impl/webview/WebViewInterceptor;", "Lcom/dynatrace/android/sessionreplay/tracking/interceptors/WebLoadInterceptor;", "trackingHandler", "Lkotlin/Function2;", "Landroid/view/View;", "", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "weakWebViewMap", "Lcom/dynatrace/android/sessionreplay/tracking/utils/InterceptionCache;", "Landroid/webkit/WebView;", "Lcom/dynatrace/android/sessionreplay/tracking/helpers/WebViewClientProxy;", "interceptWebView", "web", "client", "Landroid/webkit/WebViewClient;", "setWebViewClient", "webView", "webViewClient", "trackinglayer_release"})
public final class WebViewInterceptor
implements WebLoadInterceptor {
    @NotNull
    private final Function2<View, String, Unit> trackingHandler;
    @NotNull
    private final InterceptionCache<WebView, WebViewClientProxy> weakWebViewMap;

    public WebViewInterceptor(@NotNull Function2<? super View, ? super String, Unit> trackingHandler) {
        Intrinsics.checkNotNullParameter(trackingHandler, (String)"trackingHandler");
        this.trackingHandler = trackingHandler;
        this.weakWebViewMap = new InterceptionCache();
    }

    @Override
    public void interceptWebView(@NotNull WebView web) {
        Intrinsics.checkNotNullParameter((Object)web, (String)"web");
        WebViewClientProxy existingClient = this.weakWebViewMap.get(web);
        if (existingClient == null) {
            existingClient = new WebViewClientProxy(null, this.trackingHandler);
            this.setWebViewClient(web, existingClient);
        }
    }

    @Override
    public void interceptWebView(@NotNull WebView web, @NotNull WebViewClient client) {
        WebViewClientProxy existingClient;
        Intrinsics.checkNotNullParameter((Object)web, (String)"web");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        WebViewClientProxy webViewClientProxy = existingClient = this.weakWebViewMap.get(web);
        if (webViewClientProxy != null) {
            WebViewClientProxy it = webViewClientProxy;
            boolean bl = false;
            it.setWebViewClient(client);
            WebViewUtilsKt.tryWebViewClient$default(web, it, null, 2, null);
        } else {
            WebViewInterceptor $this$interceptWebView_u24lambda_u241 = this;
            boolean bl = false;
            $this$interceptWebView_u24lambda_u241.setWebViewClient(web, new WebViewClientProxy(client, $this$interceptWebView_u24lambda_u241.trackingHandler));
        }
    }

    private final void setWebViewClient(WebView webView, WebViewClientProxy webViewClient) {
        WebViewUtilsKt.tryWebViewClient(webView, webViewClient, (Function0<Unit>)((Function0)() -> WebViewInterceptor.setWebViewClient$lambda$2(this, webView, webViewClient)));
    }

    private static final Unit setWebViewClient$lambda$2(WebViewInterceptor this$0, WebView $webView, WebViewClientProxy $webViewClient) {
        this$0.weakWebViewMap.set($webView, $webViewClient);
        return Unit.INSTANCE;
    }
}

