/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.logging.DTLogger;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.CompoundButtonMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/CompoundButtonTracker;", "", "observer", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "trackCompoundButtonStateChanged", "", "checked", "", "viewHolder", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "getAction", "Lcom/dynatrace/android/sessionreplay/tracking/model/CompoundButtonMetadata$Action;", "masked", "trackinglayer_release"})
public final class CompoundButtonTracker {
    @NotNull
    private final TrackingObserver observer;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public CompoundButtonTracker(@NotNull TrackingObserver observer, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.observer = observer;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackCompoundButtonStateChanged(boolean checked, @NotNull UIView viewHolder) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) break block2;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            boolean masked = this.maskingValidator.validate(view2);
            DTLogger.INSTANCE.tracking("trackCompoundButtonStateChanged with value: " + checked + " and the view is: " + (masked ? "masked" : "not masked"));
            CompoundButtonMetadata.Action action = this.getAction(masked, checked);
            CompoundButtonMetadata eventMetaData = new CompoundButtonMetadata(action);
            if (masked) {
                this.observer.onCompoundStateChanged(new Date(), viewMetadata, this.maskingValidator.validate(view2), eventMetaData, null);
            } else {
                this.screenshotHandler.takeScreenshot(viewHolder, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> CompoundButtonTracker.trackCompoundButtonStateChanged$lambda$1$lambda$0(this, viewMetadata, view2, eventMetaData, arg_0)));
            }
        }
    }

    private final CompoundButtonMetadata.Action getAction(boolean masked, boolean checked) {
        CompoundButtonMetadata.Action action;
        if (masked) {
            action = CompoundButtonMetadata.Action.UNDEFINED;
        } else {
            boolean bl = checked;
            if (bl) {
                action = CompoundButtonMetadata.Action.ON;
            } else if (!bl) {
                action = CompoundButtonMetadata.Action.OFF;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return action;
    }

    private static final Unit trackCompoundButtonStateChanged$lambda$1$lambda$0(CompoundButtonTracker this$0, ViewMetadata $viewMetadata, View $view, CompoundButtonMetadata $eventMetaData, Bitmap bitmap) {
        this$0.observer.onCompoundStateChanged(new Date(), $viewMetadata, this$0.maskingValidator.validate($view), $eventMetaData, bitmap);
        return Unit.INSTANCE;
    }
}

