/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.sessionreplay.tracking.extensions.StringExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.InputEndMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.InputStartMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.KeystrokeMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fJ\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000bJ*\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/InputTracker;", "", "trackingObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "currentModificationId", "", "currentInputStart", "Ljava/util/Date;", "isCurrentInputEventSecured", "", "isCurrentInputEventMasked", "startInput", "", "viewHolder", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "field", "name", "value", "isSecured", "isMasked", "addKeystroke", "currentView", "keystrokeValue", "endInput", "processValue", "Companion", "trackinglayer_release"})
public final class InputTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TrackingObserver trackingObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;
    @Nullable
    private String currentModificationId;
    @Nullable
    private Date currentInputStart;
    private boolean isCurrentInputEventSecured;
    private boolean isCurrentInputEventMasked;
    @NotNull
    private static final String DEFAULT_NAME = "Unknown";
    @NotNull
    private static final String MASKED = "***";

    public InputTracker(@NotNull TrackingObserver trackingObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)trackingObserver, (String)"trackingObserver");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.trackingObserver = trackingObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void startInput(@NotNull UIView viewHolder, @Nullable String field, @Nullable String name, @NotNull String value, boolean isSecured, boolean isMasked) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.isCurrentInputEventSecured = isSecured;
            this.isCurrentInputEventMasked = isMasked;
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            Date date = new Date();
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = name;
            if (string2 == null) {
                string2 = DEFAULT_NAME;
            }
            InputStartMetadata startMetadata = new InputStartMetadata(string, string2, field, value);
            this.trackingObserver.onInputStart(date, viewMetadata, this.maskingValidator.validate(view2), startMetadata);
            this.currentModificationId = startMetadata.getInputModificationId();
            this.currentInputStart = date;
        }
    }

    public final void addKeystroke(@NotNull UIView currentView, @NotNull String keystrokeValue) {
        Intrinsics.checkNotNullParameter((Object)currentView, (String)"currentView");
        Intrinsics.checkNotNullParameter((Object)keystrokeValue, (String)"keystrokeValue");
        if (this.isCurrentInputEventSecured || this.currentModificationId == null) {
            return;
        }
        String finalValue = this.processValue(keystrokeValue);
        Function1 endCode = arg_0 -> InputTracker.addKeystroke$lambda$3(this, currentView, finalValue, arg_0);
        if (this.isCurrentInputEventMasked) {
            endCode.invoke(null);
        } else {
            this.screenshotHandler.takeScreenshotDelayed(currentView, 10L, (Function1<? super Bitmap, Unit>)endCode);
        }
    }

    public final void endInput(@NotNull UIView currentView, @Nullable String field, @Nullable String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)currentView, (String)"currentView");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String modificationId = this.currentModificationId;
        Date inputStartTime = this.currentInputStart;
        if (modificationId == null || inputStartTime == null) {
            this.currentModificationId = null;
            this.currentInputStart = null;
            return;
        }
        String finalValue = this.processValue(value);
        Function1 endCode = arg_0 -> InputTracker.endInput$lambda$5(currentView, modificationId, name, field, inputStartTime, finalValue, this, arg_0);
        if (!this.isCurrentInputEventMasked && !this.isCurrentInputEventSecured) {
            this.screenshotHandler.takeScreenshot(currentView, (Function1<? super Bitmap, Unit>)endCode);
        } else {
            endCode.invoke(null);
        }
        this.currentModificationId = null;
        this.currentInputStart = null;
    }

    private final String processValue(String value) {
        return this.isCurrentInputEventSecured ? MASKED : (this.isCurrentInputEventMasked ? StringExtensionsKt.mask(value) : value);
    }

    private static final Unit addKeystroke$lambda$3(InputTracker this$0, UIView $currentView, String $finalValue, Bitmap bitmap) {
        block1: {
            String string = this$0.currentModificationId;
            if (string == null) break block1;
            String modificationId = string;
            boolean bl = false;
            ViewMetadata viewMetadata = $currentView.getMetadata();
            if (viewMetadata != null) {
                ViewMetadata viewMetadata2 = viewMetadata;
                boolean bl2 = false;
                TrackingObserver trackingObserver = this$0.trackingObserver;
                Date date = new Date();
                MaskingValidator maskingValidator = this$0.maskingValidator;
                View view = $currentView.getView$trackinglayer_release();
                Intrinsics.checkNotNull((Object)view);
                trackingObserver.onKeystroke(date, viewMetadata2, maskingValidator.validate(view), new KeystrokeMetadata(modificationId, $finalValue), bitmap);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit endInput$lambda$5(UIView $currentView, String $modificationId, String $name, String $field, Date $inputStartTime, String $finalValue, InputTracker this$0, Bitmap bitmap) {
        block1: {
            ViewMetadata viewMetadata = $currentView.getMetadata();
            if (viewMetadata == null) break block1;
            ViewMetadata viewMetadata2 = viewMetadata;
            boolean bl = false;
            Date endTime = new Date();
            String string = $name;
            if (string == null) {
                string = DEFAULT_NAME;
            }
            InputEndMetadata inputEndMetadata = new InputEndMetadata($modificationId, string, $field, endTime.getTime() - $inputStartTime.getTime(), $finalValue);
            TrackingObserver trackingObserver = this$0.trackingObserver;
            MaskingValidator maskingValidator = this$0.maskingValidator;
            View view = $currentView.getView$trackinglayer_release();
            Intrinsics.checkNotNull((Object)view);
            trackingObserver.onInputEnd(endTime, viewMetadata2, maskingValidator.validate(view), inputEndMetadata, bitmap);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/InputTracker$Companion;", "", "<init>", "()V", "DEFAULT_NAME", "", "MASKED", "trackinglayer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

