/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.Window;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.observer.ScreenObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/NavigationDrawerTracker;", "", "screenObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/ScreenObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/ScreenObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "trackNavigationDrawerOpened", "", "viewHolder", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "trackNavigationDrawerClosed", "trackinglayer_release"})
public final class NavigationDrawerTracker {
    @NotNull
    private final ScreenObserver screenObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public NavigationDrawerTracker(@NotNull ScreenObserver screenObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)screenObserver, (String)"screenObserver");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.screenObserver = screenObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackNavigationDrawerOpened(@NotNull UIView viewHolder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) {
                return;
            }
            View view2 = view;
            View view3 = view2.getRootView();
            if (view3 == null) break block1;
            View rootView = view3;
            boolean bl = false;
            Context context = view2.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
            Window window = ((Activity)context).getWindow();
            this.screenshotHandler.takeScreenshot(new UIView(rootView, window, null, 4, null), (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> NavigationDrawerTracker.trackNavigationDrawerOpened$lambda$1$lambda$0(this, rootView, arg_0)));
        }
    }

    public final void trackNavigationDrawerClosed(@NotNull UIView viewHolder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            View view = viewHolder.getView$trackinglayer_release();
            if (view == null) {
                return;
            }
            View view2 = view;
            View view3 = view2.getRootView();
            if (view3 == null) break block1;
            View rootView = view3;
            boolean bl = false;
            Context context = view2.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type android.app.Activity");
            Window window = ((Activity)context).getWindow();
            this.screenshotHandler.takeScreenshot(new UIView(rootView, window, null, 4, null), (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> NavigationDrawerTracker.trackNavigationDrawerClosed$lambda$3$lambda$2(this, rootView, arg_0)));
        }
    }

    private static final Unit trackNavigationDrawerOpened$lambda$1$lambda$0(NavigationDrawerTracker this$0, View $rootView, Bitmap bitmap) {
        this$0.screenObserver.onNavigationDrawerOpened(new Date(), ViewExtensionsKt.getMetadata($rootView), this$0.maskingValidator.validate($rootView), bitmap);
        return Unit.INSTANCE;
    }

    private static final Unit trackNavigationDrawerClosed$lambda$3$lambda$2(NavigationDrawerTracker this$0, View $rootView, Bitmap bitmap) {
        this$0.screenObserver.onNavigationDrawerClosed(new Date(), ViewExtensionsKt.getMetadata($rootView), this$0.maskingValidator.validate($rootView), bitmap);
        return Unit.INSTANCE;
    }
}

