/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers;

import android.graphics.Bitmap;
import android.view.View;
import com.dynatrace.android.sessionreplay.tracking.extensions.ViewExtensionsKt;
import com.dynatrace.android.sessionreplay.tracking.model.ScrollMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.observer.TrackingObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.validator.masking.MaskingValidator;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/ScrollTracker;", "", "scrollObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "maskingValidator", "Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/TrackingObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;Lcom/dynatrace/android/sessionreplay/tracking/validator/masking/MaskingValidator;)V", "trackScroll", "", "viewHolder", "Lcom/dynatrace/android/sessionreplay/tracking/model/UIView;", "scrollX", "", "scrollY", "oldScrollX", "oldScrollY", "deltaX", "deltaY", "trackinglayer_release"})
public final class ScrollTracker {
    @Nullable
    private final TrackingObserver scrollObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    @NotNull
    private final MaskingValidator maskingValidator;

    public ScrollTracker(@Nullable TrackingObserver scrollObserver, @NotNull ScreenshotHandler screenshotHandler, @NotNull MaskingValidator maskingValidator) {
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        Intrinsics.checkNotNullParameter((Object)maskingValidator, (String)"maskingValidator");
        this.scrollObserver = scrollObserver;
        this.screenshotHandler = screenshotHandler;
        this.maskingValidator = maskingValidator;
    }

    public final void trackScroll(@NotNull UIView viewHolder, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
        int deltaX = scrollX - oldScrollX;
        int deltaY = scrollY - oldScrollY;
        this.trackScroll(viewHolder, deltaX, deltaY);
    }

    public final void trackScroll(@NotNull UIView viewHolder, int deltaX, int deltaY) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)viewHolder, (String)"viewHolder");
            if (this.scrollObserver == null) {
                return;
            }
            View view = viewHolder.getContainerView();
            if (view == null) break block1;
            View view2 = view;
            boolean bl = false;
            ViewMetadata viewMetadata = ViewExtensionsKt.getMetadata(view2);
            this.screenshotHandler.takeScreenshot(viewHolder, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> ScrollTracker.trackScroll$lambda$1$lambda$0(this, viewMetadata, view2, deltaX, deltaY, arg_0)));
        }
    }

    private static final Unit trackScroll$lambda$1$lambda$0(ScrollTracker this$0, ViewMetadata $viewMetadata, View $view, int $deltaX, int $deltaY, Bitmap bitmap) {
        this$0.scrollObserver.onScroll(new Date(), $viewMetadata, this$0.maskingValidator.validate($view), new ScrollMetadata($deltaX, $deltaY), bitmap);
        return Unit.INSTANCE;
    }
}

