/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.trackers.compose;

import android.graphics.Bitmap;
import android.view.View;
import android.view.Window;
import androidx.compose.ui.layout.LayoutCoordinates;
import com.dynatrace.android.sessionreplay.tracking.model.InputEndMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.InputStartMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.KeystrokeMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.UIComposeView;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadata;
import com.dynatrace.android.sessionreplay.tracking.model.ViewMetadataKt;
import com.dynatrace.android.sessionreplay.tracking.observer.InputObserver;
import com.dynatrace.android.sessionreplay.tracking.screenshot.ScreenshotHandler;
import com.dynatrace.android.sessionreplay.tracking.trackers.compose.InputTracker;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J(\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J*\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/InputTrackerImpl;", "Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/InputTracker;", "inputObserver", "Lcom/dynatrace/android/sessionreplay/tracking/observer/InputObserver;", "screenshotHandler", "Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;", "<init>", "(Lcom/dynatrace/android/sessionreplay/tracking/observer/InputObserver;Lcom/dynatrace/android/sessionreplay/tracking/screenshot/ScreenshotHandler;)V", "focusStartTimestamp", "", "id", "", "startInput", "", "text", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "addKeystroke", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "endInput", "Companion", "trackinglayer_release"})
public final class InputTrackerImpl
implements InputTracker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InputObserver inputObserver;
    @NotNull
    private final ScreenshotHandler screenshotHandler;
    private long focusStartTimestamp;
    @NotNull
    private String id;
    @Deprecated
    @NotNull
    public static final String name = "ComposeInputText";

    public InputTrackerImpl(@NotNull InputObserver inputObserver, @NotNull ScreenshotHandler screenshotHandler) {
        Intrinsics.checkNotNullParameter((Object)inputObserver, (String)"inputObserver");
        Intrinsics.checkNotNullParameter((Object)screenshotHandler, (String)"screenshotHandler");
        this.inputObserver = inputObserver;
        this.screenshotHandler = screenshotHandler;
        this.id = "";
    }

    @Override
    public void startInput(@NotNull String text, @Nullable LayoutCoordinates coordinates) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (coordinates == null) {
            return;
        }
        this.focusStartTimestamp = System.currentTimeMillis();
        this.id = UUID.randomUUID().toString();
        ViewMetadata viewMetadata = new UIComposeView(ViewMetadataKt.toViewMetadata(coordinates, this.id), null, null, null, 14, null).getMetadata();
        InputStartMetadata inputStartMetadata = new InputStartMetadata(viewMetadata.getViewId(), name, "", text);
        this.inputObserver.onInputStart(new Date(), viewMetadata, false, inputStartMetadata);
    }

    @Override
    public void addKeystroke(@NotNull String text, @NotNull LayoutCoordinates coordinates, @NotNull View view, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        UIComposeView uiComposeView = new UIComposeView(ViewMetadataKt.toViewMetadata(coordinates, this.id), view, window, null, 8, null);
        ViewMetadata viewMetadata = uiComposeView.getMetadata();
        KeystrokeMetadata keystrokeMetadata = new KeystrokeMetadata(this.id, text);
        this.screenshotHandler.takeScreenshot(uiComposeView, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> InputTrackerImpl.addKeystroke$lambda$0(this, viewMetadata, keystrokeMetadata, arg_0)));
    }

    @Override
    public void endInput(@NotNull String text, @Nullable LayoutCoordinates coordinates, @NotNull View view, @NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        InputEndMetadata inputEndMetadata = new InputEndMetadata(this.id, name, "", System.currentTimeMillis() - this.focusStartTimestamp, text);
        if (coordinates != null && coordinates.isAttached()) {
            UIComposeView uiComposeView = new UIComposeView(ViewMetadataKt.toViewMetadata(coordinates, this.id), view, window, null, 8, null);
            ViewMetadata viewMetadata = uiComposeView.getMetadata();
            this.screenshotHandler.takeScreenshot(uiComposeView, (Function1<? super Bitmap, Unit>)((Function1)arg_0 -> InputTrackerImpl.endInput$lambda$1(this, viewMetadata, inputEndMetadata, arg_0)));
        } else {
            this.inputObserver.onInputEnd(new Date(), new ViewMetadata(this.id, 0, 0, 0, 0), false, inputEndMetadata, null);
        }
    }

    private static final Unit addKeystroke$lambda$0(InputTrackerImpl this$0, ViewMetadata $viewMetadata, KeystrokeMetadata $keystrokeMetadata, Bitmap bitmap) {
        this$0.inputObserver.onKeystroke(new Date(), $viewMetadata, false, $keystrokeMetadata, bitmap);
        return Unit.INSTANCE;
    }

    private static final Unit endInput$lambda$1(InputTrackerImpl this$0, ViewMetadata $viewMetadata, InputEndMetadata $inputEndMetadata, Bitmap bitmap) {
        this$0.inputObserver.onInputEnd(new Date(), $viewMetadata, false, $inputEndMetadata, bitmap);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/trackers/compose/InputTrackerImpl$Companion;", "", "<init>", "()V", "name", "", "trackinglayer_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

