/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.sessionreplay.tracking.utils;

import com.dynatrace.android.sessionreplay.tracking.helpers.EspressoTrackingIdlingResource;
import com.dynatrace.android.sessionreplay.tracking.utils.MainThreadExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u0016\u0010\u0010\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/dynatrace/android/sessionreplay/tracking/utils/Debouncer;", "", "executor", "Ljava/util/concurrent/Executor;", "<init>", "(Ljava/util/concurrent/Executor;)V", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "pendingRunnable", "Ljava/util/concurrent/ScheduledFuture;", "debounce", "", "delay", "", "block", "Lkotlin/Function0;", "execute", "cancel", "trackinglayer_release"})
public final class Debouncer {
    @NotNull
    private final Executor executor;
    @NotNull
    private final ScheduledExecutorService scheduledExecutor;
    @Nullable
    private ScheduledFuture<?> pendingRunnable;

    public Debouncer(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newScheduledThreadPool(...)");
        this.scheduledExecutor = scheduledExecutorService;
    }

    public /* synthetic */ Debouncer(Executor executor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            executor = new MainThreadExecutor();
        }
        this(executor);
    }

    public final synchronized void debounce(long delay, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.cancel();
        EspressoTrackingIdlingResource.INSTANCE.increment("Debouncer: execute");
        this.pendingRunnable = this.scheduledExecutor.schedule(() -> Debouncer.debounce$lambda$0(this, block), delay, TimeUnit.MILLISECONDS);
    }

    private final void execute(Function0<Unit> block) {
        this.executor.execute(() -> Debouncer.execute$lambda$1(block));
        EspressoTrackingIdlingResource.INSTANCE.decrement("Debouncer: end execute");
    }

    private final void cancel() {
        ScheduledFuture<?> scheduledFuture = this.pendingRunnable;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        this.pendingRunnable = null;
        EspressoTrackingIdlingResource.INSTANCE.decrement("Debouncer: cancel");
    }

    private static final void debounce$lambda$0(Debouncer this$0, Function0 $block) {
        this$0.execute((Function0<Unit>)$block);
    }

    private static final void execute$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public Debouncer() {
        this(null, 1, null);
    }
}

