/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import java.io.File;
import java.util.List;

public final class BuildArgs {
    public static String getQuarkusBuildArgs(String existingAdditionalBuildArgs, File buildAgentLib, File oneagentGraalNativeFeatureJar, String agentOptions) {
        return BuildArgs.getQuarkusBuildArgs(existingAdditionalBuildArgs, buildAgentLib, oneagentGraalNativeFeatureJar, agentOptions, null);
    }

    public static String getQuarkusBuildArgs(String existingAdditionalBuildArgs, File buildAgentLib, File oneagentGraalNativeFeatureJar, String agentOptions, List<String> additionalBuildArgs) {
        StringBuilder additionalBuildArgsBuilder = new StringBuilder();
        if (existingAdditionalBuildArgs != null && !existingAdditionalBuildArgs.isEmpty()) {
            additionalBuildArgsBuilder.append(existingAdditionalBuildArgs).append(",");
        }
        additionalBuildArgsBuilder.append("-cp,").append(BuildArgs.escapePath(oneagentGraalNativeFeatureJar.getAbsolutePath())).append(",");
        additionalBuildArgsBuilder.append("--features=").append("com.dynatrace.graalnative.features.OneAgentGraalNativeFeature").append(",");
        additionalBuildArgsBuilder.append("--enable-url-protocols=http\\,https,");
        additionalBuildArgsBuilder.append("-J-agentpath:").append(BuildArgs.escapePath(buildAgentLib.getAbsolutePath()));
        if (agentOptions != null && !agentOptions.isEmpty()) {
            additionalBuildArgsBuilder.append("=").append(BuildArgs.escapePath(agentOptions).replace(",", "\\,"));
        }
        additionalBuildArgsBuilder.append(",");
        if (additionalBuildArgs != null) {
            for (String additionalBuildArg : additionalBuildArgs) {
                additionalBuildArgsBuilder.append(additionalBuildArg).append(",");
            }
        }
        return additionalBuildArgsBuilder.toString();
    }

    public static List<String> getBuildArgs(File oneagentGraalNativeFeatureJar) {
        return List.of("-cp", oneagentGraalNativeFeatureJar.getAbsolutePath(), "--features=com.dynatrace.graalnative.features.OneAgentGraalNativeFeature", "--enable-url-protocols=http,https");
    }

    public static String getAgentPath(File buildAgentLib, String agentOptions) {
        if (agentOptions != null) {
            return String.format("-agentpath:%s=%s", buildAgentLib.getAbsolutePath(), agentOptions);
        }
        return String.format("-agentpath:%s", buildAgentLib.getAbsolutePath());
    }

    private static String escapePath(String path) {
        return path.replace("\\", "\\\\");
    }

    private BuildArgs() {
    }
}

