/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="copy-runtime-agent", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class CopyRuntimeAgentMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            Path agentDir = (Path)this.project.getContextValue("dynatrace.agent.dir");
            CopyRuntimeAgentMojo.copyRuntimeAgent(agentDir, this.project.getBuild().getDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("failed to copy runtime agent", (Exception)e);
        }
    }

    private static void copyRuntimeAgent(Path agentDir, String targetDir) throws IOException {
        Path sourceAgentDir = agentDir.resolve("runtime");
        Path targetAgentDir = Path.of(targetDir, "dynatrace", "agent");
        FileUtils.copyDirectory((File)sourceAgentDir.toFile(), (File)targetAgentDir.resolve("lib64").toFile(), (FileFilter)FileFileFilter.INSTANCE);
        CopyRuntimeAgentMojo.copyDirectory(sourceAgentDir.resolve("any"), targetAgentDir.resolve("any"));
        CopyRuntimeAgentMojo.copyDirectory(sourceAgentDir.resolve("conf"), targetAgentDir.resolve("conf"));
    }

    private static void copyDirectory(Path source, Path destination) throws IOException {
        if (!source.toFile().exists()) {
            return;
        }
        FileUtils.copyDirectory((File)source.toFile(), (File)destination.toFile());
    }
}

