/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.ConfigurationException;
import com.dynatrace.buildtools.graalnative.DynatraceAgentDirectoryUtils;
import com.dynatrace.buildtools.graalnative.DynatraceLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.maven.project.MavenProject;

public final class DynatraceAgentDirectory {
    public static final String DYNATRACE_AGENT_DIR_CONTEXT_KEY = "dynatrace.agent.dir";
    private static final String DYNATRACE_AGENT_DIR_PROPERTY_NAME = "dynatrace.agent.dir";
    private static final String DYNATRACE_AGENT_ZIP_PROPERTY_NAME = "dynatrace.agent.zip";

    public static File setup(MavenProject project, DynatraceLogger logger) throws ConfigurationException, IOException {
        File agentDir;
        String dynatraceAgentDirProperty = project.getProperties().getProperty("dynatrace.agent.dir");
        if (dynatraceAgentDirProperty != null && !dynatraceAgentDirProperty.isEmpty()) {
            agentDir = new File(dynatraceAgentDirProperty);
        } else {
            String dynatraceAgentZipProperty = project.getProperties().getProperty(DYNATRACE_AGENT_ZIP_PROPERTY_NAME);
            if (dynatraceAgentZipProperty == null || dynatraceAgentZipProperty.isEmpty()) {
                throw new ConfigurationException(String.format("one of the properties '%s' or '%s' must be provided", "dynatrace.agent.dir", DYNATRACE_AGENT_ZIP_PROPERTY_NAME));
            }
            File dynatraceAgentZip = new File(dynatraceAgentZipProperty);
            File extractDir = new File(project.getBuild().getDirectory(), "tmp");
            agentDir = new File(extractDir, "graalnative");
            if (!agentDir.exists()) {
                DynatraceAgentDirectory.extractZip(dynatraceAgentZip.toPath(), extractDir.toPath(), logger);
            }
        }
        DynatraceAgentDirectoryUtils.checkAgentDirStructure(agentDir);
        return agentDir;
    }

    public static Path determineAgentDir(MavenProject project) {
        String dynatraceAgentDirProperty = project.getProperties().getProperty("dynatrace.agent.dir");
        if (dynatraceAgentDirProperty != null && !dynatraceAgentDirProperty.isEmpty()) {
            return Path.of(dynatraceAgentDirProperty, new String[0]);
        }
        return Path.of(project.getBuild().getDirectory(), "tmp", "graalnative");
    }

    private static void extractZip(Path archive, Path destination, DynatraceLogger logger) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(archive, new OpenOption[0]));){
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                Optional<Path> sanitizedPath = DynatraceAgentDirectory.sanitizePath(zipEntry, destination);
                if (sanitizedPath.isEmpty()) {
                    logger.warn("invalid zip entry '%s' in archive '%s'", zipEntry.getName(), archive);
                } else {
                    Path zipEntryPath = sanitizedPath.get();
                    if (zipEntry.isDirectory()) {
                        Files.createDirectories(zipEntryPath, new FileAttribute[0]);
                    } else {
                        Path zipEntryParentPath = zipEntryPath.getParent();
                        if (zipEntryParentPath != null && !Files.exists(zipEntryParentPath, new LinkOption[0])) {
                            Files.createDirectories(zipEntryParentPath, new FileAttribute[0]);
                        }
                        Files.copy(zipInputStream, zipEntryPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    zipInputStream.closeEntry();
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
    }

    private static Optional<Path> sanitizePath(ZipEntry entry, Path destination) {
        Path normalizedPath = destination.resolve(entry.getName()).normalize();
        if (!normalizedPath.startsWith(destination)) {
            return Optional.empty();
        }
        return Optional.of(normalizedPath);
    }

    private DynatraceAgentDirectory() {
    }
}

