/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;

public class DynatraceAgentDirectoryUtils {
    private static final List<String> EXPECTED_AGENT_DIR_ENTRIES = List.of(Constants.RUNTIME_AGENT_LIB_PATH, Constants.BUILD_AGENT_LIB_PATH, "buildtime/any/java/oneagent-graalnative-feature.jar", "buildtime/any/java/oneagentjava.jar", "buildtime/any/java/oneagentjava.8.jar", "buildtime/any/java/oneagentjava.11.jar", "buildtime/any/java/oneagentjava.17.jar", "buildtime/any/java/oneagentjava.rmi.jar", "buildtime/any/java/oneagentjava.sql.jar", "buildtime/any/java/oneagentjava.addons.jar", "buildtime/any/java/ruleset");

    public static void checkAgentDirStructure(File agentDir) throws FileNotFoundException {
        if (!agentDir.exists()) {
            throw new FileNotFoundException(agentDir.getAbsolutePath());
        }
        for (String entry : EXPECTED_AGENT_DIR_ENTRIES) {
            File entryFile = new File(agentDir, entry);
            if (entryFile.exists()) continue;
            throw new FileNotFoundException(entryFile.getAbsolutePath());
        }
    }

    private DynatraceAgentDirectoryUtils() {
    }
}

