/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.buildtools.graalnative;

import com.dynatrace.buildtools.graalnative.BuildArgs;
import com.dynatrace.buildtools.graalnative.Constants;
import com.dynatrace.buildtools.graalnative.DynatraceAgentDirectory;
import com.dynatrace.buildtools.graalnative.DynatraceLogger;
import com.dynatrace.buildtools.graalnative.Xpp3DomUtils;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="dynatrace-native-build-tools")
public class DynatraceNativeImageExtension
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    private static final String DYNATRACE_AGENT_OPTIONS_PROPERTY_NAME = "dynatrace.agent.options";
    private static final String GRAALVM_BUILDTOOLS_NATIVE_MAVEN_PLUGIN = "org.graalvm.buildtools:native-maven-plugin";
    private static final String QUARKUS_NATIVE_ADDITIONAL_BUILD_ARGS = "quarkus.native.additional-build-args";
    private DynatraceLogger logger;

    public void enableLogging(Logger logger) {
        this.logger = DynatraceLogger.of(logger);
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        for (MavenProject project : session.getProjects()) {
            Path agentDir = DynatraceAgentDirectory.determineAgentDir(project);
            project.setContextValue("dynatrace.agent.dir", (Object)agentDir);
            Path buildAgentLib = agentDir.resolve(Constants.BUILD_AGENT_LIB_PATH);
            Path oneagentGraalNativeFeatureJar = agentDir.resolve("buildtime/any/java/oneagent-graalnative-feature.jar");
            String agentOptions = project.getProperties().getProperty(DYNATRACE_AGENT_OPTIONS_PROPERTY_NAME);
            Plugin quarkusPlugin = DynatraceNativeImageExtension.getQuarkusPlugin(project);
            if (quarkusPlugin != null) {
                String existingAdditionalBuildArgs = project.getProperties().getProperty(QUARKUS_NATIVE_ADDITIONAL_BUILD_ARGS);
                String additionalBuildArgs = BuildArgs.getQuarkusBuildArgs(existingAdditionalBuildArgs, buildAgentLib.toFile(), oneagentGraalNativeFeatureJar.toFile(), agentOptions);
                project.getProperties().setProperty(QUARKUS_NATIVE_ADDITIONAL_BUILD_ARGS, additionalBuildArgs);
                continue;
            }
            Plugin graalNativePlugin = project.getPlugin(GRAALVM_BUILDTOOLS_NATIVE_MAVEN_PLUGIN);
            if (graalNativePlugin == null) {
                throw new MavenExecutionException(String.format("failed to extend Graal native plugin configuration for Dynatrace agent: failed to find Graal native plugin '%s'", GRAALVM_BUILDTOOLS_NATIVE_MAVEN_PLUGIN), project.getFile());
            }
            Xpp3Dom graalNativePluginConfig = (Xpp3Dom)graalNativePlugin.getConfiguration();
            if (graalNativePluginConfig == null) {
                graalNativePluginConfig = new Xpp3Dom("configuration");
                graalNativePlugin.setConfiguration((Object)graalNativePluginConfig);
            }
            DynatraceNativeImageExtension.addAgentConfiguration(graalNativePluginConfig, buildAgentLib, oneagentGraalNativeFeatureJar, agentOptions);
            for (PluginExecution pluginExecution : graalNativePlugin.getExecutions()) {
                Xpp3Dom pluginExecutionConfig = (Xpp3Dom)pluginExecution.getConfiguration();
                if (pluginExecutionConfig == null) {
                    pluginExecutionConfig = new Xpp3Dom("configuration");
                    pluginExecution.setConfiguration((Object)pluginExecutionConfig);
                }
                DynatraceNativeImageExtension.addAgentConfiguration(pluginExecutionConfig, buildAgentLib, oneagentGraalNativeFeatureJar, agentOptions);
            }
        }
    }

    private static void addAgentConfiguration(Xpp3Dom configuration, Path buildAgentLib, Path oneagentGraalNativeFeatureJar, String agentOptions) {
        List<String> buildArgs = BuildArgs.getBuildArgs(oneagentGraalNativeFeatureJar.toFile());
        Xpp3Dom buildArgsDom = Xpp3DomUtils.getOrAddChild(configuration, "buildArgs");
        for (String buildArg : buildArgs) {
            Xpp3Dom buildArgDom = new Xpp3Dom("buildArg");
            buildArgDom.setValue(buildArg);
            buildArgsDom.addChild(buildArgDom);
        }
        String agentPath = BuildArgs.getAgentPath(buildAgentLib.toFile(), agentOptions);
        Xpp3Dom jvmArgs = Xpp3DomUtils.getOrAddChild(configuration, "jvmArgs");
        Xpp3Dom agentPathArg = new Xpp3Dom("jvmArg");
        agentPathArg.setValue(agentPath);
        jvmArgs.addChild(agentPathArg);
    }

    private static Plugin getQuarkusPlugin(MavenProject project) {
        Plugin quarkusPlugin = project.getPlugin("io.quarkus.platform:quarkus-maven-plugin");
        if (quarkusPlugin != null) {
            return quarkusPlugin;
        }
        return project.getPlugin("io.quarkus:quarkus-maven-plugin");
    }
}

